/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient;

import io.reactiverse.pgclient.PgConnectOptionsConverter;
import io.reactiverse.pgclient.SslMode;
import io.reactiverse.pgclient.impl.PgConnectionUriParser;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TrustOptions;
import java.util.Map;
import java.util.Set;

@DataObject(generateConverter=true)
public class PgConnectOptions
extends NetClientOptions {
    public static final String DEFAULT_HOST = "localhost";
    public static int DEFAULT_PORT = 5432;
    public static final String DEFAULT_DATABASE = "db";
    public static final String DEFAULT_USER = "user";
    public static final String DEFAULT_PASSWORD = "pass";
    public static final boolean DEFAULT_CACHE_PREPARED_STATEMENTS = false;
    public static final int DEFAULT_PIPELINING_LIMIT = 256;
    public static final SslMode DEFAULT_SSLMODE = SslMode.DISABLE;
    private String host;
    private int port;
    private String database;
    private String user;
    private String password;
    private boolean cachePreparedStatements;
    private int pipeliningLimit;
    private SslMode sslMode;

    public static PgConnectOptions fromUri(String connectionUri) throws IllegalArgumentException {
        JsonObject parsedConfiguration = PgConnectionUriParser.parse(connectionUri);
        return new PgConnectOptions(parsedConfiguration);
    }

    public static PgConnectOptions fromEnv() {
        PgConnectOptions pgConnectOptions = new PgConnectOptions();
        if (System.getenv("PGHOSTADDR") == null) {
            if (System.getenv("PGHOST") != null) {
                pgConnectOptions.setHost(System.getenv("PGHOST"));
            }
        } else {
            pgConnectOptions.setHost(System.getenv("PGHOSTADDR"));
        }
        if (System.getenv("PGPORT") != null) {
            try {
                pgConnectOptions.setPort(Integer.parseInt(System.getenv("PGPORT")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (System.getenv("PGDATABASE") != null) {
            pgConnectOptions.setDatabase(System.getenv("PGDATABASE"));
        }
        if (System.getenv("PGUSER") != null) {
            pgConnectOptions.setUser(System.getenv("PGUSER"));
        }
        if (System.getenv("PGPASSWORD") != null) {
            pgConnectOptions.setPassword(System.getenv("PGPASSWORD"));
        }
        if (System.getenv("PGSSLMODE") != null) {
            pgConnectOptions.setSslMode(SslMode.of(System.getenv("PGSSLMODE")));
        }
        return pgConnectOptions;
    }

    public PgConnectOptions() {
        this.init();
    }

    public PgConnectOptions(JsonObject json) {
        super(json);
        this.init();
        PgConnectOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public PgConnectOptions(PgConnectOptions other) {
        super((NetClientOptions)other);
        this.host = other.host;
        this.port = other.port;
        this.database = other.database;
        this.user = other.user;
        this.password = other.password;
        this.pipeliningLimit = other.pipeliningLimit;
        this.cachePreparedStatements = other.cachePreparedStatements;
        this.sslMode = other.sslMode;
    }

    public String getHost() {
        return this.host;
    }

    public PgConnectOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public PgConnectOptions setPort(int port) {
        this.port = port;
        return this;
    }

    public String getDatabase() {
        return this.database;
    }

    public PgConnectOptions setDatabase(String database) {
        this.database = database;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public PgConnectOptions setUser(String user) {
        this.user = user;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public PgConnectOptions setPassword(String password) {
        this.password = password;
        return this;
    }

    public int getPipeliningLimit() {
        return this.pipeliningLimit;
    }

    public PgConnectOptions setPipeliningLimit(int pipeliningLimit) {
        if (pipeliningLimit < 1) {
            throw new IllegalArgumentException();
        }
        this.pipeliningLimit = pipeliningLimit;
        return this;
    }

    public boolean getCachePreparedStatements() {
        return this.cachePreparedStatements;
    }

    public PgConnectOptions setCachePreparedStatements(boolean cachePreparedStatements) {
        this.cachePreparedStatements = cachePreparedStatements;
        return this;
    }

    public SslMode getSslMode() {
        return this.sslMode;
    }

    public PgConnectOptions setSslMode(SslMode sslmode) {
        this.sslMode = sslmode;
        return this;
    }

    public PgConnectOptions setSendBufferSize(int sendBufferSize) {
        return (PgConnectOptions)super.setSendBufferSize(sendBufferSize);
    }

    public PgConnectOptions setReceiveBufferSize(int receiveBufferSize) {
        return (PgConnectOptions)super.setReceiveBufferSize(receiveBufferSize);
    }

    public PgConnectOptions setReuseAddress(boolean reuseAddress) {
        return (PgConnectOptions)super.setReuseAddress(reuseAddress);
    }

    public PgConnectOptions setTrafficClass(int trafficClass) {
        return (PgConnectOptions)super.setTrafficClass(trafficClass);
    }

    public PgConnectOptions setTcpNoDelay(boolean tcpNoDelay) {
        return (PgConnectOptions)super.setTcpNoDelay(tcpNoDelay);
    }

    public PgConnectOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        return (PgConnectOptions)super.setTcpKeepAlive(tcpKeepAlive);
    }

    public PgConnectOptions setSoLinger(int soLinger) {
        return (PgConnectOptions)super.setSoLinger(soLinger);
    }

    public PgConnectOptions setUsePooledBuffers(boolean usePooledBuffers) {
        return (PgConnectOptions)super.setUsePooledBuffers(usePooledBuffers);
    }

    public PgConnectOptions setIdleTimeout(int idleTimeout) {
        return (PgConnectOptions)super.setIdleTimeout(idleTimeout);
    }

    public PgConnectOptions setSsl(boolean ssl) {
        if (ssl) {
            this.setSslMode(SslMode.VERIFY_CA);
        } else {
            this.setSslMode(SslMode.DISABLE);
        }
        return this;
    }

    public PgConnectOptions setKeyCertOptions(KeyCertOptions options) {
        return (PgConnectOptions)super.setKeyCertOptions(options);
    }

    public PgConnectOptions setKeyStoreOptions(JksOptions options) {
        return (PgConnectOptions)super.setKeyStoreOptions(options);
    }

    public PgConnectOptions setPfxKeyCertOptions(PfxOptions options) {
        return (PgConnectOptions)super.setPfxKeyCertOptions(options);
    }

    public PgConnectOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        return (PgConnectOptions)super.setPemKeyCertOptions(options);
    }

    public PgConnectOptions setTrustOptions(TrustOptions options) {
        return (PgConnectOptions)super.setTrustOptions(options);
    }

    public PgConnectOptions setTrustStoreOptions(JksOptions options) {
        return (PgConnectOptions)super.setTrustStoreOptions(options);
    }

    public PgConnectOptions setPemTrustOptions(PemTrustOptions options) {
        return (PgConnectOptions)super.setPemTrustOptions(options);
    }

    public PgConnectOptions setPfxTrustOptions(PfxOptions options) {
        return (PgConnectOptions)super.setPfxTrustOptions(options);
    }

    public PgConnectOptions addEnabledCipherSuite(String suite) {
        return (PgConnectOptions)super.addEnabledCipherSuite(suite);
    }

    public PgConnectOptions addEnabledSecureTransportProtocol(String protocol) {
        return (PgConnectOptions)super.addEnabledSecureTransportProtocol(protocol);
    }

    public PgConnectOptions addCrlPath(String crlPath) throws NullPointerException {
        return (PgConnectOptions)super.addCrlPath(crlPath);
    }

    public PgConnectOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        return (PgConnectOptions)super.addCrlValue(crlValue);
    }

    public PgConnectOptions setTrustAll(boolean trustAll) {
        return (PgConnectOptions)super.setTrustAll(trustAll);
    }

    public PgConnectOptions setConnectTimeout(int connectTimeout) {
        return (PgConnectOptions)super.setConnectTimeout(connectTimeout);
    }

    public PgConnectOptions setMetricsName(String metricsName) {
        return (PgConnectOptions)super.setMetricsName(metricsName);
    }

    public PgConnectOptions setReconnectAttempts(int attempts) {
        return (PgConnectOptions)super.setReconnectAttempts(attempts);
    }

    public PgConnectOptions setHostnameVerificationAlgorithm(String hostnameVerificationAlgorithm) {
        return (PgConnectOptions)super.setHostnameVerificationAlgorithm(hostnameVerificationAlgorithm);
    }

    public PgConnectOptions setLogActivity(boolean logEnabled) {
        return (PgConnectOptions)super.setLogActivity(logEnabled);
    }

    public PgConnectOptions setReconnectInterval(long interval) {
        return (PgConnectOptions)super.setReconnectInterval(interval);
    }

    public PgConnectOptions setProxyOptions(ProxyOptions proxyOptions) {
        return (PgConnectOptions)super.setProxyOptions(proxyOptions);
    }

    public PgConnectOptions setLocalAddress(String localAddress) {
        return (PgConnectOptions)super.setLocalAddress(localAddress);
    }

    public PgConnectOptions setUseAlpn(boolean useAlpn) {
        return (PgConnectOptions)super.setUseAlpn(useAlpn);
    }

    public PgConnectOptions setSslEngineOptions(SSLEngineOptions sslEngineOptions) {
        return (PgConnectOptions)super.setSslEngineOptions(sslEngineOptions);
    }

    public PgConnectOptions setJdkSslEngineOptions(JdkSSLEngineOptions sslEngineOptions) {
        return (PgConnectOptions)super.setJdkSslEngineOptions(sslEngineOptions);
    }

    public PgConnectOptions setOpenSslEngineOptions(OpenSSLEngineOptions sslEngineOptions) {
        return (PgConnectOptions)super.setOpenSslEngineOptions(sslEngineOptions);
    }

    public PgConnectOptions setReusePort(boolean reusePort) {
        return (PgConnectOptions)super.setReusePort(reusePort);
    }

    public PgConnectOptions setTcpFastOpen(boolean tcpFastOpen) {
        return (PgConnectOptions)super.setTcpFastOpen(tcpFastOpen);
    }

    public PgConnectOptions setTcpCork(boolean tcpCork) {
        return (PgConnectOptions)super.setTcpCork(tcpCork);
    }

    public PgConnectOptions setTcpQuickAck(boolean tcpQuickAck) {
        return (PgConnectOptions)super.setTcpQuickAck(tcpQuickAck);
    }

    public PgConnectOptions setEnabledSecureTransportProtocols(Set<String> enabledSecureTransportProtocols) {
        return (PgConnectOptions)super.setEnabledSecureTransportProtocols(enabledSecureTransportProtocols);
    }

    private void init() {
        this.host = DEFAULT_HOST;
        this.port = DEFAULT_PORT;
        this.database = DEFAULT_DATABASE;
        this.user = DEFAULT_USER;
        this.password = DEFAULT_PASSWORD;
        this.cachePreparedStatements = false;
        this.pipeliningLimit = 256;
        this.sslMode = DEFAULT_SSLMODE;
    }

    public JsonObject toJson() {
        JsonObject json = super.toJson();
        PgConnectOptionsConverter.toJson(this, json);
        return json;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PgConnectOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PgConnectOptions that = (PgConnectOptions)((Object)o);
        if (!this.host.equals(that.host)) {
            return false;
        }
        if (this.port != that.port) {
            return false;
        }
        if (!this.database.equals(that.database)) {
            return false;
        }
        if (!this.user.equals(that.user)) {
            return false;
        }
        if (!this.password.equals(that.password)) {
            return false;
        }
        if (this.cachePreparedStatements != that.cachePreparedStatements) {
            return false;
        }
        if (this.pipeliningLimit != that.pipeliningLimit) {
            return false;
        }
        return this.sslMode == that.sslMode;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.host.hashCode();
        result = 31 * result + this.port;
        result = 31 * result + this.database.hashCode();
        result = 31 * result + this.user.hashCode();
        result = 31 * result + this.password.hashCode();
        result = 31 * result + (this.cachePreparedStatements ? 1 : 0);
        result = 31 * result + this.pipeliningLimit;
        result = 31 * result + this.sslMode.hashCode();
        return result;
    }

    public boolean isUsingDomainSocket() {
        return this.getHost().startsWith("/");
    }
}

