/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.data;

import io.reactiverse.pgclient.data.CircleConverter;
import io.reactiverse.pgclient.data.Point;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.Map;

@DataObject(generateConverter=true)
public class Circle {
    private Point centerPoint;
    private double radius;

    public Circle() {
        this(new Point(), 0.0);
    }

    public Circle(Point centerPoint, double radius) {
        this.centerPoint = centerPoint;
        this.radius = radius;
    }

    public Circle(JsonObject json) {
        CircleConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public Point getCenterPoint() {
        return this.centerPoint;
    }

    public void setCenterPoint(Point centerPoint) {
        this.centerPoint = centerPoint;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Circle that = (Circle)o;
        if (this.radius != that.radius) {
            return false;
        }
        return this.centerPoint.equals(that.centerPoint);
    }

    public int hashCode() {
        int result = this.centerPoint.hashCode();
        long temp = Double.doubleToLongBits(this.radius);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "Circle<" + this.centerPoint.toString() + "," + this.radius + ">";
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        CircleConverter.toJson(this, json);
        return json;
    }
}

