/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.impl;

import io.reactiverse.pgclient.PgClient;
import io.reactiverse.pgclient.PgResult;
import io.reactiverse.pgclient.PgRowSet;
import io.reactiverse.pgclient.Row;
import io.reactiverse.pgclient.Tuple;
import io.reactiverse.pgclient.impl.ArrayTuple;
import io.reactiverse.pgclient.impl.CommandScheduler;
import io.reactiverse.pgclient.impl.ExtendedBatchQueryCommand;
import io.reactiverse.pgclient.impl.ExtendedQueryCommand;
import io.reactiverse.pgclient.impl.PgResultBase;
import io.reactiverse.pgclient.impl.PgResultBuilder;
import io.reactiverse.pgclient.impl.PgResultImpl;
import io.reactiverse.pgclient.impl.PgRowSetImpl;
import io.reactiverse.pgclient.impl.PrepareStatementCommand;
import io.reactiverse.pgclient.impl.PreparedStatement;
import io.reactiverse.pgclient.impl.SimpleQueryCommand;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collector;

public abstract class PgClientBase<C extends PgClient>
implements PgClient,
CommandScheduler {
    public C query(String sql, Handler<AsyncResult<PgRowSet>> handler) {
        return this.query(sql, false, PgRowSetImpl.FACTORY, PgRowSetImpl.COLLECTOR, handler);
    }

    public <R> C query(String sql, Collector<Row, ?, R> collector, Handler<AsyncResult<PgResult<R>>> handler) {
        return this.query(sql, true, PgResultImpl::new, collector, handler);
    }

    private <R1, R2 extends PgResultBase<R1, R2>, R3 extends PgResult<R1>> C query(String sql, boolean singleton, Function<R1, R2> factory, Collector<Row, ?, R1> collector, Handler<AsyncResult<R3>> handler) {
        PgResultBuilder<R1, R2, R3> b = new PgResultBuilder<R1, R2, R3>(factory, handler);
        this.schedule(new SimpleQueryCommand<R1>(sql, singleton, collector, b), b);
        return (C)this;
    }

    public C preparedQuery(String sql, Tuple arguments, Handler<AsyncResult<PgRowSet>> handler) {
        return this.preparedQuery(sql, arguments, false, PgRowSetImpl.FACTORY, PgRowSetImpl.COLLECTOR, handler);
    }

    public <R> C preparedQuery(String sql, Tuple arguments, Collector<Row, ?, R> collector, Handler<AsyncResult<PgResult<R>>> handler) {
        return this.preparedQuery(sql, arguments, true, PgResultImpl::new, collector, handler);
    }

    private <R1, R2 extends PgResultBase<R1, R2>, R3 extends PgResult<R1>> C preparedQuery(String sql, Tuple arguments, boolean singleton, Function<R1, R2> factory, Collector<Row, ?, R1> collector, Handler<AsyncResult<R3>> handler) {
        this.schedule(new PrepareStatementCommand(sql), cr -> {
            if (cr.succeeded()) {
                PreparedStatement ps = (PreparedStatement)cr.result();
                String msg = ps.prepare((List)((Object)arguments));
                if (msg != null) {
                    handler.handle((Object)Future.failedFuture((String)msg));
                } else {
                    PgResultBuilder b = new PgResultBuilder(factory, handler);
                    cr.scheduler.schedule(new ExtendedQueryCommand(ps, arguments, singleton, collector, b), b);
                }
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)cr.cause()));
            }
        });
        return (C)this;
    }

    public C preparedQuery(String sql, Handler<AsyncResult<PgRowSet>> handler) {
        return this.preparedQuery(sql, ArrayTuple.EMPTY, handler);
    }

    public <R> C preparedQuery(String sql, Collector<Row, ?, R> collector, Handler<AsyncResult<PgResult<R>>> handler) {
        return this.preparedQuery(sql, ArrayTuple.EMPTY, collector, handler);
    }

    public C preparedBatch(String sql, List<Tuple> batch, Handler<AsyncResult<PgRowSet>> handler) {
        return this.preparedBatch(sql, batch, false, PgRowSetImpl.FACTORY, PgRowSetImpl.COLLECTOR, handler);
    }

    public <R> C preparedBatch(String sql, List<Tuple> batch, Collector<Row, ?, R> collector, Handler<AsyncResult<PgResult<R>>> handler) {
        return this.preparedBatch(sql, batch, true, PgResultImpl::new, collector, handler);
    }

    private <R1, R2 extends PgResultBase<R1, R2>, R3 extends PgResult<R1>> C preparedBatch(String sql, List<Tuple> batch, boolean singleton, Function<R1, R2> factory, Collector<Row, ?, R1> collector, Handler<AsyncResult<R3>> handler) {
        this.schedule(new PrepareStatementCommand(sql), cr -> {
            if (cr.succeeded()) {
                PreparedStatement ps = (PreparedStatement)cr.result();
                for (Tuple args : batch) {
                    String msg = ps.prepare((List)((Object)args));
                    if (msg == null) continue;
                    handler.handle((Object)Future.failedFuture((String)msg));
                    return;
                }
                PgResultBuilder b = new PgResultBuilder(factory, handler);
                cr.scheduler.schedule(new ExtendedBatchQueryCommand(ps, batch, singleton, collector, b), b);
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)cr.cause()));
            }
        });
        return (C)this;
    }
}

