/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.impl;

import io.reactiverse.pgclient.PgConnectOptions;
import io.reactiverse.pgclient.SslMode;
import io.reactiverse.pgclient.impl.CommandResponse;
import io.reactiverse.pgclient.impl.Connection;
import io.reactiverse.pgclient.impl.SocketConnection;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.NetSocketInternal;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrustOptions;

public class PgConnectionFactory {
    private final NetClient client;
    private final Context ctx;
    private final boolean registerCloseHook;
    private final String host;
    private final int port;
    private final SslMode sslMode;
    private final TrustOptions trustOptions;
    private final String hostnameVerificationAlgorithm;
    private final String database;
    private final String username;
    private final String password;
    private final boolean cachePreparedStatements;
    private final int pipeliningLimit;
    private final boolean isUsingDomainSocket;
    private final Closeable hook = this::close;

    public PgConnectionFactory(Context context, boolean registerCloseHook, PgConnectOptions options) {
        this.registerCloseHook = registerCloseHook;
        this.ctx = context;
        if (registerCloseHook) {
            this.ctx.addCloseHook(this.hook);
        }
        NetClientOptions netClientOptions = new NetClientOptions((NetClientOptions)options);
        netClientOptions.setSsl(false);
        this.sslMode = options.getSslMode();
        this.hostnameVerificationAlgorithm = netClientOptions.getHostnameVerificationAlgorithm();
        this.trustOptions = netClientOptions.getTrustOptions();
        this.host = options.getHost();
        this.port = options.getPort();
        this.database = options.getDatabase();
        this.username = options.getUser();
        this.password = options.getPassword();
        this.cachePreparedStatements = options.getCachePreparedStatements();
        this.pipeliningLimit = options.getPipeliningLimit();
        this.isUsingDomainSocket = options.isUsingDomainSocket();
        this.client = context.owner().createNetClient(netClientOptions);
    }

    private void close(Handler<AsyncResult<Void>> completionHandler) {
        this.client.close();
        completionHandler.handle((Object)Future.succeededFuture());
    }

    public void close() {
        if (this.registerCloseHook) {
            this.ctx.removeCloseHook(this.hook);
        }
        this.client.close();
    }

    public void create(Handler<? super CommandResponse<Connection>> completionHandler) {
        this.connect((Handler<AsyncResult<SocketConnection>>)((Handler)ar -> {
            if (ar.succeeded()) {
                SocketConnection conn = (SocketConnection)ar.result();
                conn.initializeCodec();
                conn.sendStartupMessage(this.username, this.password, this.database, completionHandler);
            } else {
                completionHandler.handle(CommandResponse.failure(ar.cause()));
            }
        }));
    }

    public void connect(Handler<AsyncResult<SocketConnection>> handler) {
        switch (this.sslMode) {
            case DISABLE: {
                this.doConnect(false, handler);
                break;
            }
            case ALLOW: {
                this.doConnect(false, (Handler<AsyncResult<SocketConnection>>)((Handler)ar -> {
                    if (ar.succeeded()) {
                        handler.handle((Object)Future.succeededFuture((Object)ar.result()));
                    } else {
                        this.doConnect(true, handler);
                    }
                }));
                break;
            }
            case PREFER: {
                this.doConnect(true, (Handler<AsyncResult<SocketConnection>>)((Handler)ar -> {
                    if (ar.succeeded()) {
                        handler.handle((Object)Future.succeededFuture((Object)ar.result()));
                    } else {
                        this.doConnect(false, handler);
                    }
                }));
                break;
            }
            case VERIFY_FULL: {
                if (this.hostnameVerificationAlgorithm == null || this.hostnameVerificationAlgorithm.isEmpty()) {
                    handler.handle((Object)Future.failedFuture((Throwable)new IllegalArgumentException("Host verification algorithm must be specified under verify-full sslmode")));
                    return;
                }
            }
            case VERIFY_CA: {
                if (this.trustOptions == null) {
                    handler.handle((Object)Future.failedFuture((Throwable)new IllegalArgumentException("Trust options must be specified under verify-full or verify-ca sslmode")));
                    return;
                }
            }
            case REQUIRE: {
                this.doConnect(true, handler);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported SSL mode");
            }
        }
    }

    private void doConnect(boolean ssl, Handler<AsyncResult<SocketConnection>> handler) {
        if (Vertx.currentContext() != this.ctx) {
            throw new IllegalStateException();
        }
        SocketAddress socketAddress = !this.isUsingDomainSocket ? SocketAddress.inetSocketAddress((int)this.port, (String)this.host) : SocketAddress.domainSocketAddress((String)(this.host + "/.s.PGSQL." + this.port));
        Future future = Future.future().setHandler(ar -> {
            if (ar.succeeded()) {
                NetSocketInternal socket = (NetSocketInternal)ar.result();
                SocketConnection conn = this.newSocketConnection(socket);
                if (ssl && !this.isUsingDomainSocket) {
                    conn.upgradeToSSLConnection((Handler<AsyncResult<Void>>)((Handler)ar2 -> {
                        if (ar2.succeeded()) {
                            handler.handle((Object)Future.succeededFuture((Object)conn));
                        } else {
                            handler.handle((Object)Future.failedFuture((Throwable)ar2.cause()));
                        }
                    }));
                } else {
                    handler.handle((Object)Future.succeededFuture((Object)conn));
                }
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
        try {
            this.client.connect(socketAddress, null, (Handler)future);
        }
        catch (Exception e) {
            future.fail((Throwable)e);
        }
    }

    private SocketConnection newSocketConnection(NetSocketInternal socket) {
        return new SocketConnection(socket, this.cachePreparedStatements, this.pipeliningLimit, this.ctx);
    }
}

