/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.impl;

import io.reactiverse.pgclient.impl.codec.ColumnDesc;
import io.reactiverse.pgclient.impl.codec.DataFormat;
import io.reactiverse.pgclient.impl.codec.decoder.ParameterDescription;
import io.reactiverse.pgclient.impl.codec.decoder.RowDescription;
import io.reactiverse.pgclient.impl.codec.encoder.Bind;
import java.util.Arrays;
import java.util.List;

class PreparedStatement {
    private static final ColumnDesc[] EMPTY_COLUMNS = new ColumnDesc[0];
    final String sql;
    final Bind bind;
    private final ParameterDescription paramDesc;
    final RowDescription rowDesc;

    PreparedStatement(String sql, long statement, ParameterDescription paramDesc, RowDescription rowDesc) {
        if (rowDesc != null) {
            rowDesc = new RowDescription((ColumnDesc[])Arrays.stream(rowDesc.columns()).map(c -> new ColumnDesc(c.getName(), c.getRelationId(), c.getRelationAttributeNo(), c.getDataType(), c.getLength(), c.getTypeModifier(), c.getDataType().supportsBinary ? DataFormat.BINARY : DataFormat.TEXT)).toArray(ColumnDesc[]::new));
        }
        this.paramDesc = paramDesc;
        this.rowDesc = rowDesc;
        this.sql = sql;
        this.bind = new Bind(statement, paramDesc != null ? paramDesc.getParamDataTypes() : null, rowDesc != null ? rowDesc.columns() : EMPTY_COLUMNS);
    }

    String prepare(List<Object> values) {
        return this.paramDesc.prepare(values);
    }
}

