/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.DecoderException;
import io.reactiverse.pgclient.impl.CloseConnectionCommand;
import io.reactiverse.pgclient.impl.CommandBase;
import io.reactiverse.pgclient.impl.CommandResponse;
import io.reactiverse.pgclient.impl.Connection;
import io.reactiverse.pgclient.impl.InitCommand;
import io.reactiverse.pgclient.impl.PrepareStatementCommand;
import io.reactiverse.pgclient.impl.PreparedStatement;
import io.reactiverse.pgclient.impl.StringLongSequence;
import io.reactiverse.pgclient.impl.codec.decoder.InitiateSslHandler;
import io.reactiverse.pgclient.impl.codec.decoder.MessageDecoder;
import io.reactiverse.pgclient.impl.codec.decoder.NoticeResponse;
import io.reactiverse.pgclient.impl.codec.decoder.NotificationResponse;
import io.reactiverse.pgclient.impl.codec.encoder.MessageEncoder;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.NetSocketInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SocketConnection
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(SocketConnection.class);
    private final NetSocketInternal socket;
    private final ArrayDeque<CommandBase<?>> inflight = new ArrayDeque();
    private final ArrayDeque<CommandBase<?>> pending = new ArrayDeque();
    private final Context context;
    private Status status = Status.CONNECTED;
    private Connection.Holder holder;
    private final Map<String, CachedPreparedStatement> psCache;
    private final StringLongSequence psSeq = new StringLongSequence();
    private final int pipeliningLimit;
    private MessageDecoder decoder;
    private MessageEncoder encoder;
    int processId;
    int secretKey;

    public SocketConnection(NetSocketInternal socket, boolean cachePreparedStatements, int pipeliningLimit, Context context) {
        this.socket = socket;
        this.context = context;
        this.psCache = cachePreparedStatements ? new ConcurrentHashMap() : null;
        this.pipeliningLimit = pipeliningLimit;
    }

    public Context context() {
        return this.context;
    }

    void upgradeToSSLConnection(Handler<AsyncResult<Void>> completionHandler) {
        ChannelPipeline pipeline = this.socket.channelHandlerContext().pipeline();
        Future upgradeFuture = Future.future();
        upgradeFuture.setHandler(ar -> {
            if (ar.succeeded()) {
                completionHandler.handle((Object)Future.succeededFuture());
            } else {
                Throwable cause = ar.cause();
                if (cause instanceof DecoderException) {
                    DecoderException err = (DecoderException)cause;
                    cause = err.getCause();
                }
                completionHandler.handle((Object)Future.failedFuture((Throwable)cause));
            }
        });
        pipeline.addBefore("handler", "initiate-ssl-handler", (ChannelHandler)new InitiateSslHandler(this, (Future<Void>)upgradeFuture));
    }

    void initializeCodec() {
        this.decoder = new MessageDecoder(this.inflight, this.socket.channelHandlerContext().alloc());
        this.encoder = new MessageEncoder(this.socket.channelHandlerContext());
        ChannelPipeline pipeline = this.socket.channelHandlerContext().pipeline();
        pipeline.addBefore("handler", "decoder", (ChannelHandler)this.decoder);
        this.socket.closeHandler(this::handleClosed);
        this.socket.exceptionHandler(this::handleException);
        this.socket.messageHandler(msg -> {
            try {
                this.handleMessage(msg);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        });
    }

    void sendStartupMessage(String username, String password, String database, Handler<? super CommandResponse<Connection>> completionHandler) {
        InitCommand cmd = new InitCommand(this, username, password, database);
        cmd.handler = completionHandler;
        this.schedule(cmd);
    }

    void sendCancelRequestMessage(int processId, int secretKey, Handler<AsyncResult<Void>> handler) {
        Buffer buffer = Buffer.buffer((int)16);
        buffer.appendInt(16);
        buffer.appendInt(80877102);
        buffer.appendInt(processId);
        buffer.appendInt(secretKey);
        this.socket.write(buffer, ar -> {
            if (ar.succeeded()) {
                if (this.status == Status.CONNECTED) {
                    this.status = Status.CLOSING;
                    this.socket.close();
                }
                handler.handle((Object)Future.succeededFuture());
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    public NetSocketInternal socket() {
        return this.socket;
    }

    @Override
    public boolean isSsl() {
        return this.socket.isSsl();
    }

    @Override
    public void init(Connection.Holder holder) {
        this.holder = holder;
    }

    @Override
    public void close(Connection.Holder holder) {
        if (Vertx.currentContext() == this.context) {
            if (this.status == Status.CONNECTED) {
                this.status = Status.CLOSING;
                this.pending.add(CloseConnectionCommand.INSTANCE);
                this.checkPending();
            }
        } else {
            this.context.runOnContext(v -> this.close(holder));
        }
    }

    @Override
    public void schedule(CommandBase<?> cmd) {
        if (cmd.handler == null) {
            throw new IllegalArgumentException();
        }
        if (Vertx.currentContext() != this.context) {
            throw new IllegalStateException();
        }
        if (cmd instanceof PrepareStatementCommand) {
            PrepareStatementCommand psCmd = (PrepareStatementCommand)cmd;
            Map<String, CachedPreparedStatement> psCache = this.psCache;
            if (psCache != null) {
                CachedPreparedStatement cached = psCache.get(psCmd.sql);
                if (cached != null) {
                    Handler handler = psCmd.handler;
                    cached.get((Handler<? super CommandResponse<PreparedStatement>>)handler);
                    return;
                }
                psCmd.statement = this.psSeq.next();
                psCmd.cached = cached = new CachedPreparedStatement();
                psCache.put(psCmd.sql, cached);
                Handler a = psCmd.handler;
                psCmd.cached.get((Handler<? super CommandResponse<PreparedStatement>>)a);
                psCmd.handler = psCmd.cached;
            }
        }
        if (this.status == Status.CONNECTED) {
            this.pending.add(cmd);
            this.checkPending();
        } else {
            cmd.fail((Throwable)new VertxException("Connection not open " + (Object)((Object)this.status)));
        }
    }

    @Override
    public int getProcessId() {
        return this.processId;
    }

    @Override
    public int getSecretKey() {
        return this.secretKey;
    }

    private void checkPending() {
        if (this.inflight.size() < this.pipeliningLimit) {
            CommandBase<?> cmd;
            while (this.inflight.size() < this.pipeliningLimit && (cmd = this.pending.poll()) != null) {
                this.inflight.add(cmd);
                this.decoder.run(cmd);
                cmd.exec(this.encoder);
            }
            this.encoder.flush();
        }
    }

    private void handleMessage(Object msg) {
        if (msg instanceof CommandResponse) {
            CommandBase<?> cmd = this.inflight.poll();
            this.checkPending();
            cmd.handler.handle(msg);
        } else if (msg instanceof NotificationResponse) {
            this.handleNotification((NotificationResponse)msg);
        } else if (msg instanceof NoticeResponse) {
            this.handleNotice((NoticeResponse)msg);
        }
    }

    private void handleNotification(NotificationResponse response) {
        if (this.holder != null) {
            this.holder.handleNotification(response.getProcessId(), response.getChannel(), response.getPayload());
        }
    }

    private void handleNotice(NoticeResponse notice) {
        logger.warn((Object)("Backend notice: severity='" + notice.getSeverity() + "', code='" + notice.getCode() + "', message='" + notice.getMessage() + "', detail='" + notice.getDetail() + "', hint='" + notice.getHint() + "', position='" + notice.getPosition() + "', internalPosition='" + notice.getInternalPosition() + "', internalQuery='" + notice.getInternalQuery() + "', where='" + notice.getWhere() + "', file='" + notice.getFile() + "', line='" + notice.getLine() + "', routine='" + notice.getRoutine() + "', schema='" + notice.getSchema() + "', table='" + notice.getTable() + "', column='" + notice.getColumn() + "', dataType='" + notice.getDataType() + "', constraint='" + notice.getConstraint() + "'"));
    }

    private void handleClosed(Void v) {
        this.handleClose(null);
    }

    private synchronized void handleException(Throwable t) {
        if (t instanceof DecoderException) {
            DecoderException err = (DecoderException)t;
            t = err.getCause();
        }
        this.handleClose(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClose(Throwable t) {
        if (this.status != Status.CLOSED) {
            this.status = Status.CLOSED;
            if (t != null) {
                SocketConnection socketConnection = this;
                synchronized (socketConnection) {
                    if (this.holder != null) {
                        this.holder.handleException(t);
                    }
                }
            }
            Throwable cause = t == null ? new VertxException("closed") : t;
            for (ArrayDeque q : Arrays.asList(this.inflight, this.pending)) {
                CommandBase cmd;
                while ((cmd = (CommandBase)q.poll()) != null) {
                    CommandBase c = cmd;
                    this.context.runOnContext(v -> c.fail(cause));
                }
            }
            if (this.holder != null) {
                this.holder.handleClosed();
            }
        }
    }

    static class CachedPreparedStatement
    implements Handler<CommandResponse<PreparedStatement>> {
        private CommandResponse<PreparedStatement> resp;
        private final ArrayDeque<Handler<? super CommandResponse<PreparedStatement>>> waiters = new ArrayDeque();

        CachedPreparedStatement() {
        }

        void get(Handler<? super CommandResponse<PreparedStatement>> handler) {
            if (this.resp != null) {
                handler.handle(this.resp);
            } else {
                this.waiters.add(handler);
            }
        }

        public void handle(CommandResponse<PreparedStatement> event) {
            Handler<? super CommandResponse<PreparedStatement>> waiter;
            this.resp = event;
            while ((waiter = this.waiters.poll()) != null) {
                waiter.handle(this.resp);
            }
        }
    }

    static enum Status {
        CLOSED,
        CONNECTED,
        CLOSING;

    }
}

