/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.impl.codec;

import io.reactiverse.pgclient.impl.codec.DataFormat;
import io.reactiverse.pgclient.impl.codec.DataType;
import java.util.Objects;

public class ColumnDesc {
    private final String name;
    private final int relationId;
    private final DataType dataType;
    private final DataFormat dataFormat;
    private final short relationAttributeNo;
    private final short length;
    private final int typeModifier;

    public ColumnDesc(String name, int relationId, short relationAttributeNo, DataType dataType, short length, int typeModifier, DataFormat dataFormat) {
        this.name = name;
        this.dataType = dataType;
        this.dataFormat = dataFormat;
        this.length = length;
        this.relationId = relationId;
        this.relationAttributeNo = relationAttributeNo;
        this.typeModifier = typeModifier;
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public int getRelationId() {
        return this.relationId;
    }

    public short getRelationAttributeNo() {
        return this.relationAttributeNo;
    }

    public short getLength() {
        return this.length;
    }

    public int getTypeModifier() {
        return this.typeModifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnDesc column = (ColumnDesc)o;
        return this.relationId == column.relationId && this.relationAttributeNo == column.relationAttributeNo && this.length == column.length && this.typeModifier == column.typeModifier && Objects.equals(this.name, column.name) && this.dataType == column.dataType && this.dataFormat == column.dataFormat;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.dataType, this.dataFormat, this.relationId, this.relationAttributeNo, this.length, this.typeModifier});
    }

    public String toString() {
        return "Column{name='" + this.name + '\'' + ", dataType=" + (Object)((Object)this.dataType) + ", dataFormat=" + (Object)((Object)this.dataFormat) + ", relationId=" + this.relationId + ", relationAttributeNo=" + this.relationAttributeNo + ", length=" + this.length + ", typeModifier=" + this.typeModifier + '}';
    }
}

