/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.impl.codec.decoder;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderException;
import io.reactiverse.pgclient.impl.SocketConnection;
import io.vertx.core.Future;
import io.vertx.core.VertxException;

public class InitiateSslHandler
extends ChannelInboundHandlerAdapter {
    private static final int code = 80877103;
    private final SocketConnection conn;
    private final Future<Void> upgradeFuture;

    public InitiateSslHandler(SocketConnection conn, Future<Void> upgradeFuture) {
        this.conn = conn;
        this.upgradeFuture = upgradeFuture;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ByteBuf byteBuf = Unpooled.buffer();
        byteBuf.writeInt(0);
        byteBuf.writeInt(80877103);
        byteBuf.setInt(0, byteBuf.writerIndex());
        ctx.writeAndFlush((Object)byteBuf);
        super.channelActive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf byteBuf = (ByteBuf)msg;
        byte b = byteBuf.getByte(0);
        byteBuf.release();
        switch (b) {
            case 83: {
                this.conn.socket().upgradeToSsl(v -> {
                    ctx.pipeline().remove((ChannelHandler)this);
                    this.upgradeFuture.complete();
                });
                break;
            }
            case 78: {
                this.upgradeFuture.fail((Throwable)new Exception("Postgres Server does not handle SSL connection"));
                break;
            }
            default: {
                this.upgradeFuture.fail((Throwable)new Exception("Invalid SSL connection message"));
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof DecoderException) {
            DecoderException err = (DecoderException)cause;
            cause = err.getCause();
        }
        this.upgradeFuture.tryFail(cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.upgradeFuture.tryFail((Throwable)new VertxException("SSL handshake failed", true));
    }
}

