/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.rxjava.pgclient;

import io.reactiverse.pgclient.PgConnectOptions;
import io.reactiverse.pgclient.PgPoolOptions;
import io.reactiverse.rxjava.pgclient.PgConnection;
import io.reactiverse.rxjava.pgclient.PgPool;
import io.reactiverse.rxjava.pgclient.PgRowSet;
import io.reactiverse.rxjava.pgclient.Tuple;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.Vertx;
import java.util.List;
import java.util.stream.Collectors;
import rx.Single;

@RxGen(value=io.reactiverse.pgclient.PgClient.class)
public class PgClient {
    public static final TypeArg<PgClient> __TYPE_ARG = new TypeArg(obj -> new PgClient((io.reactiverse.pgclient.PgClient)obj), PgClient::getDelegate);
    private final io.reactiverse.pgclient.PgClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PgClient that = (PgClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public PgClient(io.reactiverse.pgclient.PgClient delegate) {
        this.delegate = delegate;
    }

    public io.reactiverse.pgclient.PgClient getDelegate() {
        return this.delegate;
    }

    public static PgPool pool() {
        PgPool ret = PgPool.newInstance(io.reactiverse.pgclient.PgClient.pool());
        return ret;
    }

    public static PgPool pool(String connectionUri) {
        PgPool ret = PgPool.newInstance(io.reactiverse.pgclient.PgClient.pool(connectionUri));
        return ret;
    }

    public static PgPool pool(Vertx vertx) {
        PgPool ret = PgPool.newInstance(io.reactiverse.pgclient.PgClient.pool(vertx.getDelegate()));
        return ret;
    }

    public static PgPool pool(Vertx vertx, String connectionUri) {
        PgPool ret = PgPool.newInstance(io.reactiverse.pgclient.PgClient.pool(vertx.getDelegate(), connectionUri));
        return ret;
    }

    public static PgPool pool(PgPoolOptions options) {
        PgPool ret = PgPool.newInstance(io.reactiverse.pgclient.PgClient.pool(options));
        return ret;
    }

    public static PgPool pool(Vertx vertx, PgPoolOptions options) {
        PgPool ret = PgPool.newInstance(io.reactiverse.pgclient.PgClient.pool(vertx.getDelegate(), options));
        return ret;
    }

    public static void connect(Vertx vertx, PgConnectOptions options, final Handler<AsyncResult<PgConnection>> handler) {
        io.reactiverse.pgclient.PgClient.connect(vertx.getDelegate(), options, new Handler<AsyncResult<io.reactiverse.pgclient.PgConnection>>(){

            public void handle(AsyncResult<io.reactiverse.pgclient.PgConnection> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)PgConnection.newInstance((io.reactiverse.pgclient.PgConnection)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public static Single<PgConnection> rxConnect(Vertx vertx, PgConnectOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> PgClient.connect(vertx, options, (Handler<AsyncResult<PgConnection>>)fut)));
    }

    public static void connect(Vertx vertx, final Handler<AsyncResult<PgConnection>> handler) {
        io.reactiverse.pgclient.PgClient.connect(vertx.getDelegate(), new Handler<AsyncResult<io.reactiverse.pgclient.PgConnection>>(){

            public void handle(AsyncResult<io.reactiverse.pgclient.PgConnection> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)PgConnection.newInstance((io.reactiverse.pgclient.PgConnection)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public static Single<PgConnection> rxConnect(Vertx vertx) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> PgClient.connect(vertx, (Handler<AsyncResult<PgConnection>>)fut)));
    }

    public static void connect(Vertx vertx, String connectionUri, final Handler<AsyncResult<PgConnection>> handler) {
        io.reactiverse.pgclient.PgClient.connect(vertx.getDelegate(), connectionUri, new Handler<AsyncResult<io.reactiverse.pgclient.PgConnection>>(){

            public void handle(AsyncResult<io.reactiverse.pgclient.PgConnection> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)PgConnection.newInstance((io.reactiverse.pgclient.PgConnection)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public static Single<PgConnection> rxConnect(Vertx vertx, String connectionUri) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> PgClient.connect(vertx, connectionUri, (Handler<AsyncResult<PgConnection>>)fut)));
    }

    public PgClient query(String sql, final Handler<AsyncResult<PgRowSet>> handler) {
        this.delegate.query(sql, new Handler<AsyncResult<io.reactiverse.pgclient.PgRowSet>>(){

            public void handle(AsyncResult<io.reactiverse.pgclient.PgRowSet> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)PgRowSet.newInstance((io.reactiverse.pgclient.PgRowSet)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<PgRowSet> rxQuery(String sql) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.query(sql, (Handler<AsyncResult<PgRowSet>>)fut)));
    }

    public PgClient preparedQuery(String sql, final Handler<AsyncResult<PgRowSet>> handler) {
        this.delegate.preparedQuery(sql, new Handler<AsyncResult<io.reactiverse.pgclient.PgRowSet>>(){

            public void handle(AsyncResult<io.reactiverse.pgclient.PgRowSet> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)PgRowSet.newInstance((io.reactiverse.pgclient.PgRowSet)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<PgRowSet> rxPreparedQuery(String sql) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.preparedQuery(sql, (Handler<AsyncResult<PgRowSet>>)fut)));
    }

    public PgClient preparedQuery(String sql, Tuple arguments, final Handler<AsyncResult<PgRowSet>> handler) {
        this.delegate.preparedQuery(sql, arguments.getDelegate(), new Handler<AsyncResult<io.reactiverse.pgclient.PgRowSet>>(){

            public void handle(AsyncResult<io.reactiverse.pgclient.PgRowSet> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)PgRowSet.newInstance((io.reactiverse.pgclient.PgRowSet)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<PgRowSet> rxPreparedQuery(String sql, Tuple arguments) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.preparedQuery(sql, arguments, (Handler<AsyncResult<PgRowSet>>)fut)));
    }

    public PgClient preparedBatch(String sql, List<Tuple> batch, final Handler<AsyncResult<PgRowSet>> handler) {
        this.delegate.preparedBatch(sql, batch.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), new Handler<AsyncResult<io.reactiverse.pgclient.PgRowSet>>(){

            public void handle(AsyncResult<io.reactiverse.pgclient.PgRowSet> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)PgRowSet.newInstance((io.reactiverse.pgclient.PgRowSet)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<PgRowSet> rxPreparedBatch(String sql, List<Tuple> batch) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.preparedBatch(sql, batch, (Handler<AsyncResult<PgRowSet>>)fut)));
    }

    public static PgClient newInstance(io.reactiverse.pgclient.PgClient arg) {
        return arg != null ? new PgClient(arg) : null;
    }
}

