/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module reactive-pg-client-js/json */
var utils = require('vertx-js/util/utils');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JJson = Java.type('io.reactiverse.pgclient.data.Json');

/**
 @class
*/
var Json = function(j_val) {

  var j_json = j_val;
  var that = this;

  var __super_create = this.create;
  var __super_value = this.value;
  /**

   @public

   @return {Object}
   */
  this.value =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnTypeUnknown(j_json["value()"]()) ;
    } else if (typeof __super_value != 'undefined') {
      return __super_value.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_json;
};

Json._jclass = utils.getJavaClass("io.reactiverse.pgclient.data.Json");
Json._jtype = {accept: function(obj) {
    return Json._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(Json.prototype, {});
    Json.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
Json._create = function(jdel) {var obj = Object.create(Json.prototype, {});
  Json.apply(obj, arguments);
  return obj;
}
/**

 @memberof module:reactive-pg-client-js/json
 @param value {Object} 
 @return {Json}
 */
Json.create =  function(value) {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] !== 'function') {
    return utils.convReturnVertxGen(Json, JJson["create(java.lang.Object)"](utils.convParamTypeUnknown(__args[0]))) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = Json;