/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module reactive-pg-client-js/pg_client */
var utils = require('vertx-js/util/utils');
var PgPool = require('reactive-pg-client-js/pg_pool');
var Vertx = require('vertx-js/vertx');
var Tuple = require('reactive-pg-client-js/tuple');
var PgConnection = require('reactive-pg-client-js/pg_connection');
var PgRowSet = require('reactive-pg-client-js/pg_row_set');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JPgClient = Java.type('io.reactiverse.pgclient.PgClient');
var PgConnectOptions = Java.type('io.reactiverse.pgclient.PgConnectOptions');
var PgPoolOptions = Java.type('io.reactiverse.pgclient.PgPoolOptions');

/**
 Defines the client operations with a Postgres Database.

 @class
*/
var PgClient = function(j_val) {

  var j_pgClient = j_val;
  var that = this;

  var __super_pool = this.pool;
  var __super_pool = this.pool;
  var __super_pool = this.pool;
  var __super_pool = this.pool;
  var __super_pool = this.pool;
  var __super_pool = this.pool;
  var __super_connect = this.connect;
  var __super_connect = this.connect;
  var __super_connect = this.connect;
  var __super_query = this.query;
  var __super_preparedQuery = this.preparedQuery;
  var __super_preparedQuery = this.preparedQuery;
  var __super_preparedBatch = this.preparedBatch;
  /**
   Execute a simple query.

   @public
   @param sql {string} the query SQL 
   @param handler {function} the handler notified with the execution result 
   @return {PgClient} a reference to this, so the API can be used fluently
   */
  this.query =  function(sql, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_pgClient["query(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(PgRowSet, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_query != 'undefined') {
      return __super_query.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Prepare and execute a query.

   @public
   @param sql {string} the prepared query SQL 
   @param arguments {Tuple} the list of arguments 
   @param handler {function} the handler notified with the execution result 
   @return {PgClient} a reference to this, so the API can be used fluently
   */
  this.preparedQuery =  function() {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_pgClient["preparedQuery(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(PgRowSet, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'function') {
      j_pgClient["preparedQuery(java.lang.String,io.reactiverse.pgclient.Tuple,io.vertx.core.Handler)"](__args[0], __args[1]._jdel, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(PgRowSet, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_preparedQuery != 'undefined') {
      return __super_preparedQuery.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Prepare and execute a createBatch.

   @public
   @param sql {string} the prepared query SQL 
   @param batch {Array.<Tuple>} the batch of tuples 
   @param handler {function} the handler notified with the execution result 
   @return {PgClient} a reference to this, so the API can be used fluently
   */
  this.preparedBatch =  function(sql, batch, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1] instanceof Array && typeof __args[2] === 'function') {
      j_pgClient["preparedBatch(java.lang.String,java.util.List,io.vertx.core.Handler)"](__args[0], utils.convParamListVertxGen(__args[1]), function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(PgRowSet, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_preparedBatch != 'undefined') {
      return __super_preparedBatch.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_pgClient;
};

PgClient._jclass = utils.getJavaClass("io.reactiverse.pgclient.PgClient");
PgClient._jtype = {accept: function(obj) {
    return PgClient._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(PgClient.prototype, {});
    PgClient.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
PgClient._create = function(jdel) {var obj = Object.create(PgClient.prototype, {});
  PgClient.apply(obj, arguments);
  return obj;
}
/**
 Like {@link PgClient#pool} with a specific  instance.

 @memberof module:reactive-pg-client-js/pg_client
 @param vertx {Vertx} 
 @param options {Object} 
 @return {PgPool}
 */
PgClient.pool =  function() {
  var __args = arguments;
  if (__args.length === 0) {
    return utils.convReturnVertxGen(PgPool, JPgClient["pool()"]()) ;
  } else if (__args.length === 1 && typeof __args[0] === 'string') {
    return utils.convReturnVertxGen(PgPool, JPgClient["pool(java.lang.String)"](__args[0])) ;
  } else if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    return utils.convReturnVertxGen(PgPool, JPgClient["pool(io.vertx.core.Vertx)"](__args[0]._jdel)) ;
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string') {
    return utils.convReturnVertxGen(PgPool, JPgClient["pool(io.vertx.core.Vertx,java.lang.String)"](__args[0]._jdel, __args[1])) ;
  } else if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
    return utils.convReturnVertxGen(PgPool, JPgClient["pool(io.reactiverse.pgclient.PgPoolOptions)"](__args[0]  != null ? new PgPoolOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null)) ;
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null)) {
    return utils.convReturnVertxGen(PgPool, JPgClient["pool(io.vertx.core.Vertx,io.reactiverse.pgclient.PgPoolOptions)"](__args[0]._jdel, __args[1]  != null ? new PgPoolOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

/**
 Like {@link PgClient#connect} with options build from <code>connectionUri</code>.

 @memberof module:reactive-pg-client-js/pg_client
 @param vertx {Vertx} 
 @param connectionUri {string} 
 @param handler {function} 
 */
PgClient.connect =  function() {
  var __args = arguments;
  if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
    JPgClient["connect(io.vertx.core.Vertx,io.reactiverse.pgclient.PgConnectOptions,io.vertx.core.Handler)"](__args[0]._jdel, __args[1]  != null ? new PgConnectOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
      if (ar.succeeded()) {
        __args[2](utils.convReturnVertxGen(PgConnection, ar.result()), null);
      } else {
        __args[2](null, ar.cause());
      }
    });
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'function') {
    JPgClient["connect(io.vertx.core.Vertx,io.vertx.core.Handler)"](__args[0]._jdel, function(ar) {
      if (ar.succeeded()) {
        __args[1](utils.convReturnVertxGen(PgConnection, ar.result()), null);
      } else {
        __args[1](null, ar.cause());
      }
    });
  } else if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
    JPgClient["connect(io.vertx.core.Vertx,java.lang.String,io.vertx.core.Handler)"](__args[0]._jdel, __args[1], function(ar) {
      if (ar.succeeded()) {
        __args[2](utils.convReturnVertxGen(PgConnection, ar.result()), null);
      } else {
        __args[2](null, ar.cause());
      }
    });
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = PgClient;