/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module reactive-pg-client-js/pg_connection */
var utils = require('vertx-js/util/utils');
var PgClient = require('reactive-pg-client-js/pg_client');
var PgTransaction = require('reactive-pg-client-js/pg_transaction');
var Tuple = require('reactive-pg-client-js/tuple');
var PgPreparedQuery = require('reactive-pg-client-js/pg_prepared_query');
var PgRowSet = require('reactive-pg-client-js/pg_row_set');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JPgConnection = Java.type('io.reactiverse.pgclient.PgConnection');
var PgNotification = Java.type('io.reactiverse.pgclient.PgNotification');

/**
 A connection to Postgres.

 @class
*/
var PgConnection = function(j_val) {

  var j_pgConnection = j_val;
  var that = this;
  PgClient.call(this, j_val);

  var __super_prepare = this.prepare;
  var __super_exceptionHandler = this.exceptionHandler;
  var __super_closeHandler = this.closeHandler;
  var __super_begin = this.begin;
  var __super_notificationHandler = this.notificationHandler;
  var __super_processId = this.processId;
  var __super_secretKey = this.secretKey;
  var __super_cancelRequest = this.cancelRequest;
  var __super_isSSL = this.isSSL;
  var __super_close = this.close;
  var __super_preparedQuery = this.preparedQuery;
  var __super_query = this.query;
  var __super_preparedQuery = this.preparedQuery;
  var __super_preparedBatch = this.preparedBatch;
  /**
   Create a prepared query.

   @public
   @param sql {string} the sql 
   @param handler {function} the handler notified with the prepared query asynchronously 
   @return {PgConnection}
   */
  this.prepare =  function(sql, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_pgConnection["prepare(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(PgPreparedQuery, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_prepare != 'undefined') {
      return __super_prepare.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set an handler called with connection errors.

   @public
   @param handler {function} the handler 
   @return {PgConnection} a reference to this, so the API can be used fluently
   */
  this.exceptionHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_pgConnection["exceptionHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnThrowable(jVal));
      }) ;
      return that;
    } else if (typeof __super_exceptionHandler != 'undefined') {
      return __super_exceptionHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set an handler called when the connection is closed.

   @public
   @param handler {function} the handler 
   @return {PgConnection} a reference to this, so the API can be used fluently
   */
  this.closeHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_pgConnection["closeHandler(io.vertx.core.Handler)"](__args[0]) ;
      return that;
    } else if (typeof __super_closeHandler != 'undefined') {
      return __super_closeHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Begin a transaction and returns a {@link PgTransaction} for controlling and tracking
   this transaction.
   <p/>
   When the connection is explicitely closed, any inflight transaction is rollbacked.

   @public

   @return {PgTransaction} the transaction instance
   */
  this.begin =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(PgTransaction, j_pgConnection["begin()"]()) ;
    } else if (typeof __super_begin != 'undefined') {
      return __super_begin.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set an handler called when the connection receives notification on a channel.
   <p/>
   The handler is called with the <a href="../../dataobjects.html#PgNotification">PgNotification</a> and has access to the channel name
   and the notification payload.

   @public
   @param handler {function} the handler 
   @return {PgConnection} the transaction instance
   */
  this.notificationHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_pgConnection["notificationHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnDataObject(jVal));
      }) ;
      return that;
    } else if (typeof __super_notificationHandler != 'undefined') {
      return __super_notificationHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} The process ID of the target backend
   */
  this.processId =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_pgConnection["processId()"]() ;
    } else if (typeof __super_processId != 'undefined') {
      return __super_processId.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} The secret key for the target backend
   */
  this.secretKey =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_pgConnection["secretKey()"]() ;
    } else if (typeof __super_secretKey != 'undefined') {
      return __super_secretKey.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Send a request cancellation message to tell the server to cancel processing request in this connection.
   <br>Note: Use this with caution because the cancellation signal may or may not have any effect.

   @public
   @param handler {function} the handler notified if cancelling request is sent 
   @return {PgConnection} a reference to this, so the API can be used fluently
   */
  this.cancelRequest =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnVertxGen(PgConnection, j_pgConnection["cancelRequest(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](null, null);
        } else {
          __args[0](null, ar.cause());
        }
      })) ;
    } else if (typeof __super_cancelRequest != 'undefined') {
      return __super_cancelRequest.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean} whether the connection uses SSL
   */
  this.isSSL =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_pgConnection["isSSL()"]() ;
    } else if (typeof __super_isSSL != 'undefined') {
      return __super_isSSL.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Close the current connection after all the pending commands have been processed.

   @public

   */
  this.close =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_pgConnection["close()"]();
    } else if (typeof __super_close != 'undefined') {
      return __super_close.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param sql {string} 
   @param arguments {Tuple} 
   @param handler {function} 
   @return {PgConnection}
   */
  this.preparedQuery =  function() {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_pgConnection["preparedQuery(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(PgRowSet, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'function') {
      j_pgConnection["preparedQuery(java.lang.String,io.reactiverse.pgclient.Tuple,io.vertx.core.Handler)"](__args[0], __args[1]._jdel, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(PgRowSet, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_preparedQuery != 'undefined') {
      return __super_preparedQuery.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param sql {string} 
   @param handler {function} 
   @return {PgConnection}
   */
  this.query =  function(sql, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_pgConnection["query(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(PgRowSet, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_query != 'undefined') {
      return __super_query.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param sql {string} 
   @param batch {Array.<Tuple>} 
   @param handler {function} 
   @return {PgConnection}
   */
  this.preparedBatch =  function(sql, batch, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1] instanceof Array && typeof __args[2] === 'function') {
      j_pgConnection["preparedBatch(java.lang.String,java.util.List,io.vertx.core.Handler)"](__args[0], utils.convParamListVertxGen(__args[1]), function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(PgRowSet, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_preparedBatch != 'undefined') {
      return __super_preparedBatch.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_pgConnection;
};

PgConnection._jclass = utils.getJavaClass("io.reactiverse.pgclient.PgConnection");
PgConnection._jtype = {accept: function(obj) {
    return PgConnection._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(PgConnection.prototype, {});
    PgConnection.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
PgConnection._create = function(jdel) {var obj = Object.create(PgConnection.prototype, {});
  PgConnection.apply(obj, arguments);
  return obj;
}
module.exports = PgConnection;