require 'vertx/read_stream'
require 'vertx/util/utils.rb'
# Generated from io.reactiverse.pgclient.pubsub.PgChannel
module ReactivePgClient
  #  A channel to Postgres that tracks the subscription to a given Postgres channel using the <code>LISTEN/UNLISTEN</code> commands.
  #  <p/>
  #  When paused the channel discards the messages.
  class PgChannel
    include ::Vertx::ReadStream
    # @private
    # @param j_del [::ReactivePgClient::PgChannel] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::ReactivePgClient::PgChannel] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == PgChannel
    end
    def @@j_api_type.wrap(obj)
      PgChannel.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoReactiversePgclientPubsub::PgChannel.java_class
    end
    # @param [Fixnum] arg0 
    # @return [self]
    def fetch(arg0=nil)
      if arg0.class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(arg0)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling fetch(#{arg0})"
    end
    #  Set an handler called when the the channel get subscribed.
    # @yield the handler
    # @return [self]
    def subscribe_handler
      if block_given?
        @j_del.java_method(:subscribeHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling subscribe_handler()"
    end
    #  Set or unset an handler to be called when a the channel is notified by Postgres.
    #  <p/>
    #  <ul>
    #    <li>when the handler is set, the subscriber sends a <code>LISTEN</code> command if needed</li>
    #    <li>when the handler is unset, the subscriber sends a <code>UNLISTEN</code> command if needed</li>
    #  </ul>
    # @yield the handler
    # @return [self]
    def handler
      if block_given?
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling handler()"
    end
    #  Pause the channel, all notifications are discarded.
    # @return [self]
    def pause
      if !block_given?
        @j_del.java_method(:pause, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling pause()"
    end
    #  Resume the channel.
    # @return [self]
    def resume
      if !block_given?
        @j_del.java_method(:resume, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling resume()"
    end
    #  Set an handler to be called when no more notifications will be received.
    # @yield the handler
    # @return [self]
    def end_handler
      if block_given?
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling end_handler()"
    end
    # @yield 
    # @return [self]
    def exception_handler
      if block_given?
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exception_handler()"
    end
  end
end
