require 'reactive-pg-client/pg_pool'
require 'vertx/vertx'
require 'reactive-pg-client/tuple'
require 'reactive-pg-client/pg_connection'
require 'reactive-pg-client/pg_row_set'
require 'vertx/util/utils.rb'
# Generated from io.reactiverse.pgclient.PgClient
module ReactivePgClient
  #  Defines the client operations with a Postgres Database.
  class PgClient
    # @private
    # @param j_del [::ReactivePgClient::PgClient] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::ReactivePgClient::PgClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == PgClient
    end
    def @@j_api_type.wrap(obj)
      PgClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoReactiversePgclient::PgClient.java_class
    end
    #  Like {::ReactivePgClient::PgClient#pool} with a specific  instance.
    # @overload pool()
    # @overload pool(connectionUri)
    #   @param [String] connectionUri 
    # @overload pool(vertx)
    #   @param [::Vertx::Vertx] vertx 
    # @overload pool(options)
    #   @param [Hash] options the options for creating the pool
    # @overload pool(vertx,connectionUri)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] connectionUri 
    # @overload pool(vertx,options)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [Hash] options 
    # @return [::ReactivePgClient::PgPool]
    def self.pool(param_1=nil,param_2=nil)
      if !block_given? && param_1 == nil && param_2 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoReactiversePgclient::PgClient.java_method(:pool, []).call(),::ReactivePgClient::PgPool)
      elsif param_1.class == String && !block_given? && param_2 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoReactiversePgclient::PgClient.java_method(:pool, [Java::java.lang.String.java_class]).call(param_1),::ReactivePgClient::PgPool)
      elsif param_1.class.method_defined?(:j_del) && !block_given? && param_2 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoReactiversePgclient::PgClient.java_method(:pool, [Java::IoVertxCore::Vertx.java_class]).call(param_1.j_del),::ReactivePgClient::PgPool)
      elsif param_1.class == Hash && !block_given? && param_2 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoReactiversePgclient::PgClient.java_method(:pool, [Java::IoReactiversePgclient::PgPoolOptions.java_class]).call(Java::IoReactiversePgclient::PgPoolOptions.new(::Vertx::Util::Utils.to_json_object(param_1))),::ReactivePgClient::PgPool)
      elsif param_1.class.method_defined?(:j_del) && param_2.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoReactiversePgclient::PgClient.java_method(:pool, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class]).call(param_1.j_del,param_2),::ReactivePgClient::PgPool)
      elsif param_1.class.method_defined?(:j_del) && param_2.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoReactiversePgclient::PgClient.java_method(:pool, [Java::IoVertxCore::Vertx.java_class,Java::IoReactiversePgclient::PgPoolOptions.java_class]).call(param_1.j_del,Java::IoReactiversePgclient::PgPoolOptions.new(::Vertx::Util::Utils.to_json_object(param_2))),::ReactivePgClient::PgPool)
      end
      raise ArgumentError, "Invalid arguments when calling pool(#{param_1},#{param_2})"
    end
    #  Like {::ReactivePgClient::PgClient#connect} with options build from <code>connectionUri</code>.
    # @overload connect(vertx,handler)
    #   @param [::Vertx::Vertx] vertx 
    #   @yield 
    # @overload connect(vertx,options,handler)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [Hash] options the connect options
    #   @yield the handler called with the connection or the failure
    # @overload connect(vertx,connectionUri,handler)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] connectionUri 
    #   @yield 
    # @return [void]
    def self.connect(param_1=nil,param_2=nil)
      if param_1.class.method_defined?(:j_del) && block_given? && param_2 == nil
        return Java::IoReactiversePgclient::PgClient.java_method(:connect, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::ReactivePgClient::PgConnection) : nil) }))
      elsif param_1.class.method_defined?(:j_del) && param_2.class == Hash && block_given?
        return Java::IoReactiversePgclient::PgClient.java_method(:connect, [Java::IoVertxCore::Vertx.java_class,Java::IoReactiversePgclient::PgConnectOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1.j_del,Java::IoReactiversePgclient::PgConnectOptions.new(::Vertx::Util::Utils.to_json_object(param_2)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::ReactivePgClient::PgConnection) : nil) }))
      elsif param_1.class.method_defined?(:j_del) && param_2.class == String && block_given?
        return Java::IoReactiversePgclient::PgClient.java_method(:connect, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1.j_del,param_2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::ReactivePgClient::PgConnection) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling connect(#{param_1},#{param_2})"
    end
    #  Execute a simple query.
    # @param [String] sql the query SQL
    # @yield the handler notified with the execution result
    # @return [self]
    def query(sql=nil)
      if sql.class == String && block_given?
        @j_del.java_method(:query, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::ReactivePgClient::PgRowSet) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling query(#{sql})"
    end
    #  Prepare and execute a query.
    # @param [String] sql the prepared query SQL
    # @param [::ReactivePgClient::Tuple] arguments the list of arguments
    # @yield the handler notified with the execution result
    # @return [self]
    def prepared_query(sql=nil,arguments=nil)
      if sql.class == String && block_given? && arguments == nil
        @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::ReactivePgClient::PgRowSet) : nil) }))
        return self
      elsif sql.class == String && arguments.class.method_defined?(:j_del) && block_given?
        @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoReactiversePgclient::Tuple.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,arguments.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::ReactivePgClient::PgRowSet) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling prepared_query(#{sql},#{arguments})"
    end
    #  Prepare and execute a createBatch.
    # @param [String] sql the prepared query SQL
    # @param [Array<::ReactivePgClient::Tuple>] batch the batch of tuples
    # @yield the handler notified with the execution result
    # @return [self]
    def prepared_batch(sql=nil,batch=nil)
      if sql.class == String && batch.class == Array && block_given?
        @j_del.java_method(:preparedBatch, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,batch.map { |element| element.j_del },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::ReactivePgClient::PgRowSet) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling prepared_batch(#{sql},#{batch})"
    end
  end
end
