require 'vertx/vertx'
require 'reactive-pg-client/pg_connection'
require 'reactive-pg-client/pg_channel'
require 'vertx/util/utils.rb'
# Generated from io.reactiverse.pgclient.pubsub.PgSubscriber
module ReactivePgClient
  #  A class for managing subscriptions using <code>LISTEN/UNLISTEN</code> to Postgres channels.
  #  <p/>
  #  The subscriber manages a single connection to Postgres.
  class PgSubscriber
    # @private
    # @param j_del [::ReactivePgClient::PgSubscriber] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::ReactivePgClient::PgSubscriber] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == PgSubscriber
    end
    def @@j_api_type.wrap(obj)
      PgSubscriber.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoReactiversePgclientPubsub::PgSubscriber.java_class
    end
    #  Create a subscriber.
    # @param [::Vertx::Vertx] vertx the vertx instance
    # @param [Hash] options the connect options
    # @return [::ReactivePgClient::PgSubscriber] the subscriber
    def self.subscriber(vertx=nil,options=nil)
      if vertx.class.method_defined?(:j_del) && options.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoReactiversePgclientPubsub::PgSubscriber.java_method(:subscriber, [Java::IoVertxCore::Vertx.java_class,Java::IoReactiversePgclient::PgConnectOptions.java_class]).call(vertx.j_del,Java::IoReactiversePgclient::PgConnectOptions.new(::Vertx::Util::Utils.to_json_object(options))),::ReactivePgClient::PgSubscriber)
      end
      raise ArgumentError, "Invalid arguments when calling subscriber(#{vertx},#{options})"
    end
    #  Return a channel for the given <code>name</code>.
    # @param [String] name the channel name <p/> This will be the name of the channel exactly as held by Postgres for sending notifications. Internally this name will be truncated to the Postgres identifier maxiumum length of <code>(NAMEDATALEN = 64) - 1 == 63</code> characters, and prepared as a quoted identifier without unicode escape sequence support for use in <code>LISTEN/UNLISTEN</code> commands. Examples of channel names and corresponding <code>NOTIFY</code> commands: <ul> <li>when <code>name == "the_channel"</code>: <code>NOTIFY the_channel, 'msg'</code>, <code>NOTIFY The_Channel, 'msg'</code>, or <code>NOTIFY "the_channel", 'msg'</code> succeed in delivering a message to the created channel </li> <li>when <code>name == "The_Channel"</code>: <code>NOTIFY "The_Channel", 'msg'</code>, succeeds in delivering a message to the created channel </li> <li></li> </ul>
    # @return [::ReactivePgClient::PgChannel] the channel
    def channel(name=nil)
      if name.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:channel, [Java::java.lang.String.java_class]).call(name),::ReactivePgClient::PgChannel)
      end
      raise ArgumentError, "Invalid arguments when calling channel(#{name})"
    end
    #  Connect the subscriber to Postgres.
    # @yield the handler notified of the connection success or failure
    # @return [self]
    def connect
      if block_given?
        @j_del.java_method(:connect, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling connect()"
    end
    #  Set the reconnect policy that is executed when the subscriber is disconnected.
    #  <p/>
    #  When the subscriber is disconnected, the <code>policy</code> function is called with the actual
    #  number of retries and returns an <code>amountOfTime</code> value:
    #  <ul>
    #    <li>when <code>amountOfTime < 0</code>: the subscriber is closed and there is no retry</li>
    #    <li>when <code>amountOfTime == 0</code>: the subscriber retries to connect immediately</li>
    #    <li>when <code>amountOfTime > 0</code>: the subscriber retries after <code>amountOfTime</code> milliseconds</li>
    #  </ul>
    #  <p/>
    #  The default policy does not perform any retries.
    # @yield the policy to set
    # @return [self]
    def reconnect_policy(policy=nil)
      if block_given? && policy == nil
        @j_del.java_method(:reconnectPolicy, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(event) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling reconnect_policy(#{policy})"
    end
    #  Set an handler called when the subscriber is closed.
    # @yield the handler
    # @return [self]
    def close_handler
      if block_given?
        @j_del.java_method(:closeHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling close_handler()"
    end
    # @return [::ReactivePgClient::PgConnection] the actual connection to Postgres, it might be <code>null</code>
    def actual_connection
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:actualConnection, []).call(),::ReactivePgClient::PgConnection)
      end
      raise ArgumentError, "Invalid arguments when calling actual_connection()"
    end
    # @return [true,false] whether the subscriber is closed
    def closed?
      if !block_given?
        return @j_del.java_method(:closed, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling closed?()"
    end
    #  Close the subscriber, the retry policy will not be invoked.
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
  end
end
