/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient;

import io.reactiverse.pgclient.PgConnectOptions;
import io.reactiverse.pgclient.PgConnection;
import io.reactiverse.pgclient.PgPool;
import io.reactiverse.pgclient.PgPoolOptions;
import io.reactiverse.pgclient.PgResult;
import io.reactiverse.pgclient.PgRowSet;
import io.reactiverse.pgclient.Row;
import io.reactiverse.pgclient.Tuple;
import io.reactiverse.pgclient.impl.CommandResponse;
import io.reactiverse.pgclient.impl.Connection;
import io.reactiverse.pgclient.impl.PgConnectionFactory;
import io.reactiverse.pgclient.impl.PgConnectionImpl;
import io.reactiverse.pgclient.impl.PgPoolImpl;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import java.util.List;
import java.util.stream.Collector;

@VertxGen
public interface PgClient {
    public static PgPool pool() {
        return PgClient.pool(PgPoolOptions.fromEnv());
    }

    public static PgPool pool(String connectionUri) {
        return PgClient.pool(PgPoolOptions.fromUri(connectionUri));
    }

    public static PgPool pool(Vertx vertx) {
        return PgClient.pool(vertx, PgPoolOptions.fromEnv());
    }

    public static PgPool pool(Vertx vertx, String connectionUri) {
        return PgClient.pool(vertx, PgPoolOptions.fromUri(connectionUri));
    }

    public static PgPool pool(PgPoolOptions options) {
        if (Vertx.currentContext() != null) {
            throw new IllegalStateException("Running in a Vertx context => use PgPool#pool(Vertx, PgPoolOptions) instead");
        }
        VertxOptions vertxOptions = new VertxOptions();
        if (options.isUsingDomainSocket()) {
            vertxOptions.setPreferNativeTransport(true);
        }
        Vertx vertx = Vertx.vertx((VertxOptions)vertxOptions);
        return new PgPoolImpl(vertx, true, options);
    }

    public static PgPool pool(Vertx vertx, PgPoolOptions options) {
        return new PgPoolImpl(vertx, false, options);
    }

    public static void connect(Vertx vertx, PgConnectOptions options, Handler<AsyncResult<PgConnection>> handler) {
        Context ctx = Vertx.currentContext();
        if (ctx != null) {
            PgConnectionFactory client = new PgConnectionFactory(ctx, false, options);
            client.create((Handler<? super CommandResponse<Connection>>)((Handler)ar -> {
                if (ar.succeeded()) {
                    Connection conn = (Connection)ar.result();
                    PgConnectionImpl p = new PgConnectionImpl(client, ctx, conn);
                    conn.init(p);
                    handler.handle((Object)Future.succeededFuture((Object)p));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }));
        } else {
            vertx.runOnContext(v -> {
                if (options.isUsingDomainSocket() && !vertx.isNativeTransportEnabled()) {
                    handler.handle((Object)Future.failedFuture((String)"Native transport is not available"));
                } else {
                    PgClient.connect(vertx, options, handler);
                }
            });
        }
    }

    public static void connect(Vertx vertx, Handler<AsyncResult<PgConnection>> handler) {
        PgClient.connect(vertx, PgConnectOptions.fromEnv(), handler);
    }

    public static void connect(Vertx vertx, String connectionUri, Handler<AsyncResult<PgConnection>> handler) {
        PgClient.connect(vertx, PgConnectOptions.fromUri(connectionUri), handler);
    }

    @Fluent
    public PgClient query(String var1, Handler<AsyncResult<PgRowSet>> var2);

    @GenIgnore
    public <R> PgClient query(String var1, Collector<Row, ?, R> var2, Handler<AsyncResult<PgResult<R>>> var3);

    @Fluent
    public PgClient preparedQuery(String var1, Handler<AsyncResult<PgRowSet>> var2);

    @GenIgnore
    public <R> PgClient preparedQuery(String var1, Collector<Row, ?, R> var2, Handler<AsyncResult<PgResult<R>>> var3);

    @Fluent
    public PgClient preparedQuery(String var1, Tuple var2, Handler<AsyncResult<PgRowSet>> var3);

    @GenIgnore
    public <R> PgClient preparedQuery(String var1, Tuple var2, Collector<Row, ?, R> var3, Handler<AsyncResult<PgResult<R>>> var4);

    @Fluent
    public PgClient preparedBatch(String var1, List<Tuple> var2, Handler<AsyncResult<PgRowSet>> var3);

    @GenIgnore
    public <R> PgClient preparedBatch(String var1, List<Tuple> var2, Collector<Row, ?, R> var3, Handler<AsyncResult<PgResult<R>>> var4);

    public void close();
}

