/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.impl;

import io.reactiverse.pgclient.impl.CommandResponse;
import io.reactiverse.pgclient.impl.codec.TxStatus;
import io.reactiverse.pgclient.impl.codec.decoder.ErrorResponse;
import io.reactiverse.pgclient.impl.codec.decoder.NoticeResponse;
import io.reactiverse.pgclient.impl.codec.decoder.ParameterDescription;
import io.reactiverse.pgclient.impl.codec.decoder.RowDescription;
import io.reactiverse.pgclient.impl.codec.encoder.MessageEncoder;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;

public abstract class CommandBase<R> {
    private static final Logger logger = LoggerFactory.getLogger(CommandBase.class);
    public Handler<? super CommandResponse<R>> completionHandler;
    public Handler<NoticeResponse> noticeHandler;
    Handler<? super CommandResponse<R>> handler;
    Throwable failure;
    R result;

    public void handleBackendKeyData(int processId, int secretKey) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message BackendKeyData"));
    }

    public void handleEmptyQueryResponse() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message EmptyQueryResponse"));
    }

    public void handleParameterDescription(ParameterDescription parameterDesc) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message " + parameterDesc));
    }

    public void handleParseComplete() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message ParseComplete"));
    }

    public void handleCloseComplete() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message CloseComplete"));
    }

    public void handleRowDescription(RowDescription rowDescription) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message " + rowDescription));
    }

    public void handleNoData() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message NoData"));
    }

    public void handleNoticeResponse(NoticeResponse noticeResponse) {
        this.noticeHandler.handle((Object)noticeResponse);
    }

    public void handleErrorResponse(ErrorResponse errorResponse) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message " + errorResponse));
    }

    public void handlePortalSuspended() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message PortalSuspended"));
    }

    public void handleBindComplete() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message BindComplete"));
    }

    public void handleCommandComplete(int updated) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message CommandComplete"));
    }

    public void handleAuthenticationMD5Password(byte[] salt) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message AuthenticationMD5Password"));
    }

    public void handleAuthenticationClearTextPassword() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message AuthenticationClearTextPassword"));
    }

    public void handleAuthenticationOk() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message AuthenticationOk"));
    }

    public void handleParameterStatus(String key, String value) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message ParameterStatus"));
    }

    public void handleReadyForQuery(TxStatus txStatus) {
        CommandResponse resp = this.failure != null ? CommandResponse.failure(this.failure, txStatus) : CommandResponse.success(this.result, txStatus);
        this.completionHandler.handle(resp);
    }

    abstract void exec(MessageEncoder var1);

    final void fail(Throwable err) {
        this.handler.handle(CommandResponse.failure(err));
    }
}

