/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.impl;

import io.reactiverse.pgclient.impl.CommandScheduler;
import io.reactiverse.pgclient.impl.codec.TxStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.impl.NoStackTraceThrowable;

public abstract class CommandResponse<R>
implements AsyncResult<R> {
    CommandScheduler scheduler;
    private final TxStatus txStatus;

    static <R> CommandResponse<R> failure(String msg) {
        return CommandResponse.failure((Throwable)new NoStackTraceThrowable(msg), null);
    }

    static <R> CommandResponse<R> failure(String msg, TxStatus txStatus) {
        return CommandResponse.failure((Throwable)new NoStackTraceThrowable(msg), txStatus);
    }

    static <R> CommandResponse<R> failure(Throwable cause) {
        return CommandResponse.failure(cause, null);
    }

    static <R> CommandResponse<R> failure(final Throwable cause, TxStatus txStatus) {
        return new CommandResponse<R>(txStatus){

            public R result() {
                return null;
            }

            public Throwable cause() {
                return cause;
            }

            public boolean succeeded() {
                return false;
            }

            public boolean failed() {
                return true;
            }
        };
    }

    static <R> CommandResponse<R> success(R result) {
        return CommandResponse.success(result, null);
    }

    static <R> CommandResponse<R> success(final R result, TxStatus txStatus) {
        return new CommandResponse<R>(txStatus){

            public R result() {
                return result;
            }

            public Throwable cause() {
                return null;
            }

            public boolean succeeded() {
                return true;
            }

            public boolean failed() {
                return false;
            }
        };
    }

    public CommandResponse(TxStatus txStatus) {
        this.txStatus = txStatus;
    }

    TxStatus txStatus() {
        return this.txStatus;
    }
}

