/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.impl;

import io.reactiverse.pgclient.Row;
import io.reactiverse.pgclient.Tuple;
import io.reactiverse.pgclient.impl.ExtendedQueryCommandBase;
import io.reactiverse.pgclient.impl.PreparedStatement;
import io.reactiverse.pgclient.impl.QueryResultHandler;
import io.reactiverse.pgclient.impl.codec.encoder.MessageEncoder;
import io.reactiverse.pgclient.impl.codec.encoder.Parse;
import java.util.List;
import java.util.stream.Collector;

public class ExtendedBatchQueryCommand<T>
extends ExtendedQueryCommandBase<T> {
    private final List<Tuple> params;

    ExtendedBatchQueryCommand(PreparedStatement ps, List<Tuple> params, boolean singleton, Collector<Row, ?, T> collector, QueryResultHandler<T> resultHandler) {
        this(ps, params, 0, null, false, singleton, collector, resultHandler);
    }

    private ExtendedBatchQueryCommand(PreparedStatement ps, List<Tuple> params, int fetch, String portal, boolean suspended, boolean singleton, Collector<Row, ?, T> collector, QueryResultHandler<T> resultHandler) {
        super(ps, fetch, portal, suspended, singleton, collector, resultHandler);
        this.params = params;
    }

    @Override
    void exec(MessageEncoder out) {
        if (this.suspended) {
            out.writeExecute(this.portal, this.fetch);
            out.writeSync();
        } else {
            if (this.ps.bind.statement == 0L) {
                out.writeParse(new Parse(this.ps.sql));
            }
            if (this.params.isEmpty()) {
                this.result = false;
            } else {
                for (Tuple param : this.params) {
                    out.writeBind(this.ps.bind, this.portal, (List)((Object)param));
                    out.writeExecute(this.portal, this.fetch);
                }
            }
            out.writeSync();
        }
    }
}

