/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.impl;

import io.reactiverse.pgclient.PgException;
import io.reactiverse.pgclient.impl.CommandBase;
import io.reactiverse.pgclient.impl.CommandResponse;
import io.reactiverse.pgclient.impl.Connection;
import io.reactiverse.pgclient.impl.SocketConnection;
import io.reactiverse.pgclient.impl.codec.TxStatus;
import io.reactiverse.pgclient.impl.codec.decoder.ErrorResponse;
import io.reactiverse.pgclient.impl.codec.encoder.MessageEncoder;
import io.reactiverse.pgclient.impl.codec.encoder.PasswordMessage;
import io.reactiverse.pgclient.impl.codec.encoder.StartupMessage;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class InitCommand
extends CommandBase<Connection> {
    private final SocketConnection conn;
    private final String username;
    private final String password;
    private final String database;
    private String encoding;
    private MessageEncoder out;

    InitCommand(SocketConnection conn, String username, String password, String database) {
        this.conn = conn;
        this.username = username;
        this.password = password;
        this.database = database;
    }

    @Override
    void exec(MessageEncoder out) {
        this.out = out;
        out.writeStartupMessage(new StartupMessage(this.username, this.database));
    }

    @Override
    public void handleAuthenticationMD5Password(byte[] salt) {
        this.out.writePasswordMessage(new PasswordMessage(this.username, this.password, salt));
        this.out.flush();
    }

    @Override
    public void handleAuthenticationClearTextPassword() {
        this.out.writePasswordMessage(new PasswordMessage(this.username, this.password, null));
        this.out.flush();
    }

    @Override
    public void handleAuthenticationOk() {
    }

    @Override
    public void handleParameterStatus(String key, String value) {
        if (key.equals("client_encoding")) {
            this.encoding = value;
        }
    }

    @Override
    public void handleBackendKeyData(int processId, int secretKey) {
        this.conn.processId = processId;
        this.conn.secretKey = secretKey;
    }

    @Override
    public void handleErrorResponse(ErrorResponse errorResponse) {
        CommandResponse resp = CommandResponse.failure(new PgException(errorResponse));
        this.completionHandler.handle(resp);
    }

    @Override
    public void handleReadyForQuery(TxStatus txStatus) {
        Charset cs = null;
        try {
            cs = Charset.forName(this.encoding);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CommandResponse<SocketConnection> fut = cs == null || !cs.equals(StandardCharsets.UTF_8) ? CommandResponse.failure(this.encoding + " is not supported in the client only UTF8") : CommandResponse.success(this.conn);
        this.completionHandler.handle(fut);
    }
}

