/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.impl;

import io.reactiverse.pgclient.PgConnection;
import io.reactiverse.pgclient.PgNotification;
import io.reactiverse.pgclient.PgTransaction;
import io.reactiverse.pgclient.impl.CommandBase;
import io.reactiverse.pgclient.impl.CommandResponse;
import io.reactiverse.pgclient.impl.Connection;
import io.reactiverse.pgclient.impl.PgConnectionBase;
import io.reactiverse.pgclient.impl.PgConnectionFactory;
import io.reactiverse.pgclient.impl.SocketConnection;
import io.reactiverse.pgclient.impl.Transaction;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;

public class PgConnectionImpl
extends PgConnectionBase<PgConnectionImpl>
implements PgConnection,
Connection.Holder {
    private final PgConnectionFactory factory;
    private volatile Handler<Throwable> exceptionHandler;
    private volatile Handler<Void> closeHandler;
    private Transaction tx;
    private volatile Handler<PgNotification> notificationHandler;

    public PgConnectionImpl(PgConnectionFactory factory, Context context, Connection conn) {
        super(context, conn);
        this.factory = factory;
    }

    @Override
    public Connection connection() {
        return this.conn;
    }

    @Override
    public void handleClosed() {
        Handler<Void> handler = this.closeHandler;
        if (handler != null) {
            this.context.runOnContext(handler);
        }
    }

    @Override
    public <R> void schedule(CommandBase<R> cmd, Handler<? super CommandResponse<R>> handler) {
        cmd.handler = cr -> {
            cr.scheduler = this;
            handler.handle(cr);
        };
        this.schedule(cmd);
    }

    protected void schedule(CommandBase<?> cmd) {
        if (this.context == Vertx.currentContext()) {
            if (this.tx != null) {
                this.tx.schedule(cmd);
            } else {
                this.conn.schedule(cmd);
            }
        } else {
            this.context.runOnContext(v -> this.schedule(cmd));
        }
    }

    @Override
    public void handleException(Throwable err) {
        Handler<Throwable> handler = this.exceptionHandler;
        if (handler != null) {
            this.context.runOnContext(v -> handler.handle((Object)err));
        } else {
            err.printStackTrace();
        }
    }

    @Override
    public boolean isSSL() {
        return this.conn.isSsl();
    }

    @Override
    public PgConnection closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
        return this;
    }

    @Override
    public PgConnection notificationHandler(Handler<PgNotification> handler) {
        this.notificationHandler = handler;
        return this;
    }

    @Override
    public PgConnection exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public PgTransaction begin() {
        return this.begin(false);
    }

    PgTransaction begin(boolean closeOnEnd) {
        if (this.tx != null) {
            throw new IllegalStateException();
        }
        this.tx = new Transaction(this.context, this.conn, (Handler<Void>)((Handler)v -> {
            this.tx = null;
            if (closeOnEnd) {
                this.close();
            }
        }));
        return this.tx;
    }

    @Override
    public void handleNotification(int processId, String channel, String payload) {
        Handler<PgNotification> handler = this.notificationHandler;
        if (handler != null) {
            handler.handle((Object)new PgNotification().setProcessId(processId).setChannel(channel).setPayload(payload));
        }
    }

    @Override
    public void close() {
        if (this.context == Vertx.currentContext()) {
            if (this.tx != null) {
                this.tx.rollback((Handler<AsyncResult<Void>>)((Handler)ar -> this.conn.close(this)));
                this.tx = null;
            } else {
                this.conn.close(this);
            }
        } else {
            this.context.runOnContext(v -> this.close());
        }
    }

    @Override
    public int processId() {
        return this.conn.getProcessId();
    }

    @Override
    public int secretKey() {
        return this.conn.getSecretKey();
    }

    @Override
    public PgConnection cancelRequest(Handler<AsyncResult<Void>> handler) {
        Context current = Vertx.currentContext();
        if (current == this.context) {
            this.factory.connect((Handler<AsyncResult<SocketConnection>>)((Handler)ar -> {
                if (ar.succeeded()) {
                    SocketConnection conn = (SocketConnection)ar.result();
                    conn.sendCancelRequestMessage(this.processId(), this.secretKey(), handler);
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }));
        } else {
            this.context.runOnContext(v -> this.cancelRequest(handler));
        }
        return this;
    }
}

