/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.impl;

import io.reactiverse.pgclient.SslMode;
import io.vertx.core.json.JsonObject;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PgConnectionUriParser {
    private static final String FULL_URI_REGEX = "^postgre(?:s|sql)://(?:(\\w+(?::\\S+)?)@)?([0-9.]+|\\[[A-Za-z0-9:]+]|[A-Za-z0-9.%\\-_]+)?(?::(\\d+))?(?:/([A-Za-z0-9_\\-]+))?(?:\\?(.*))?$";
    private static final int USER_INFO_GROUP = 1;
    private static final int NET_LOCATION_GROUP = 2;
    private static final int PORT_GROUP = 3;
    private static final int DATABASE_GROUP = 4;
    private static final int PARAMETER_GROUP = 5;

    public static JsonObject parse(String connectionUri) {
        try {
            JsonObject configuration = new JsonObject();
            PgConnectionUriParser.doParse(connectionUri, configuration);
            return configuration;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse invalid connection URI: " + connectionUri, e);
        }
    }

    private static void doParse(String connectionUri, JsonObject configuration) {
        Pattern pattern = Pattern.compile(FULL_URI_REGEX);
        Matcher matcher = pattern.matcher(connectionUri);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Wrong syntax of connection URI");
        }
        PgConnectionUriParser.parseUserandPassword(matcher.group(1), configuration);
        PgConnectionUriParser.parseNetLocation(matcher.group(2), configuration);
        PgConnectionUriParser.parsePort(matcher.group(3), configuration);
        PgConnectionUriParser.parseDatabaseName(matcher.group(4), configuration);
        PgConnectionUriParser.parseParameters(matcher.group(5), configuration);
    }

    private static void parseUserandPassword(String userInfo, JsonObject configuration) {
        if (userInfo == null || userInfo.isEmpty()) {
            return;
        }
        if (PgConnectionUriParser.occurExactlyOnce(userInfo, ":")) {
            int index = userInfo.indexOf(":");
            String user = userInfo.substring(0, index);
            if (user.isEmpty()) {
                throw new IllegalArgumentException("Can not only specify the password without a concrete user");
            }
            String password = userInfo.substring(index + 1);
            configuration.put("user", PgConnectionUriParser.decodeUrl(user));
            configuration.put("password", PgConnectionUriParser.decodeUrl(password));
        } else if (!userInfo.contains(":")) {
            configuration.put("user", PgConnectionUriParser.decodeUrl(userInfo));
        } else {
            throw new IllegalArgumentException("Can not use multiple delimiters to delimit user and password");
        }
    }

    private static void parseNetLocation(String hostInfo, JsonObject configuration) {
        if (hostInfo == null || hostInfo.isEmpty()) {
            return;
        }
        PgConnectionUriParser.parseNetLocationValue(PgConnectionUriParser.decodeUrl(hostInfo), configuration);
    }

    private static void parsePort(String portInfo, JsonObject configuration) {
        int port;
        if (portInfo == null || portInfo.isEmpty()) {
            return;
        }
        try {
            port = Integer.parseInt(PgConnectionUriParser.decodeUrl(portInfo));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The post must be a valid integer");
        }
        if (port > 65535 || port <= 0) {
            throw new IllegalArgumentException("The post can only range in 1-65535");
        }
        configuration.put("port", Integer.valueOf(port));
    }

    private static void parseDatabaseName(String databaseInfo, JsonObject configuration) {
        if (databaseInfo == null || databaseInfo.isEmpty()) {
            return;
        }
        configuration.put("database", PgConnectionUriParser.decodeUrl(databaseInfo));
    }

    private static void parseParameters(String parametersInfo, JsonObject configuration) {
        if (parametersInfo == null || parametersInfo.isEmpty()) {
            return;
        }
        block18: for (String parameterPair : parametersInfo.split("&")) {
            if (parameterPair.isEmpty()) continue;
            int indexOfDelimiter = parameterPair.indexOf("=");
            if (indexOfDelimiter < 0) {
                throw new IllegalArgumentException(String.format("Missing delimiter '=' of parameters \"%s\" in the part \"%s\"", parametersInfo, parameterPair));
            }
            String key = parameterPair.substring(0, indexOfDelimiter).toLowerCase();
            String value = PgConnectionUriParser.decodeUrl(parameterPair.substring(indexOfDelimiter + 1).trim());
            switch (key) {
                case "port": {
                    PgConnectionUriParser.parsePort(value, configuration);
                    continue block18;
                }
                case "host": {
                    PgConnectionUriParser.parseNetLocationValue(value, configuration);
                    continue block18;
                }
                case "hostaddr": {
                    configuration.put("host", value);
                    continue block18;
                }
                case "user": {
                    configuration.put("user", value);
                    continue block18;
                }
                case "password": {
                    configuration.put("password", value);
                    continue block18;
                }
                case "dbname": {
                    configuration.put("database", value);
                    continue block18;
                }
                case "sslmode": {
                    configuration.put("sslMode", (Enum)SslMode.of(value));
                    continue block18;
                }
                default: {
                    configuration.put(key, value);
                }
            }
        }
    }

    private static void parseNetLocationValue(String hostValue, JsonObject configuration) {
        if (PgConnectionUriParser.isRegardedAsIpv6Address(hostValue)) {
            configuration.put("host", hostValue.substring(1, hostValue.length() - 1));
        } else {
            configuration.put("host", hostValue);
        }
    }

    private static boolean isRegardedAsIpv6Address(String hostAddress) {
        return hostAddress.startsWith("[") && hostAddress.endsWith("]");
    }

    private static String decodeUrl(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("The connection uri contains unknown characters that can not be resolved.");
        }
    }

    private static boolean occurExactlyOnce(String uri, String character) {
        return uri.contains(character) && uri.indexOf(character) == uri.lastIndexOf(character);
    }
}

