/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.impl;

import io.reactiverse.pgclient.PgCursor;
import io.reactiverse.pgclient.PgRowSet;
import io.reactiverse.pgclient.Tuple;
import io.reactiverse.pgclient.impl.PgPreparedQueryImpl;
import io.reactiverse.pgclient.impl.PgResultBuilder;
import io.reactiverse.pgclient.impl.PgRowSetImpl;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import java.util.UUID;

public class PgCursorImpl
implements PgCursor {
    private final PgPreparedQueryImpl ps;
    private final Tuple params;
    private String portal;
    private boolean closed;
    private PgResultBuilder<PgRowSet, PgRowSetImpl, PgRowSet> result;

    PgCursorImpl(PgPreparedQueryImpl ps, Tuple params) {
        this.ps = ps;
        this.params = params;
    }

    @Override
    public synchronized boolean hasMore() {
        if (this.result == null) {
            throw new IllegalStateException("No current cursor read");
        }
        return this.result.isSuspended();
    }

    @Override
    public synchronized void read(int count, Handler<AsyncResult<PgRowSet>> handler) {
        if (this.portal == null) {
            this.portal = UUID.randomUUID().toString();
            this.result = new PgResultBuilder<PgRowSet, PgRowSetImpl, PgRowSet>(PgRowSetImpl.FACTORY, handler);
            this.ps.execute(this.params, count, this.portal, false, false, PgRowSetImpl.COLLECTOR, this.result, this.result);
        } else if (this.result.isSuspended()) {
            this.result = new PgResultBuilder<PgRowSet, PgRowSetImpl, PgRowSet>(PgRowSetImpl.FACTORY, handler);
            this.ps.execute(this.params, count, this.portal, true, false, PgRowSetImpl.COLLECTOR, this.result, this.result);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public synchronized void close(Handler<AsyncResult<Void>> completionHandler) {
        if (!this.closed) {
            this.closed = true;
            if (this.portal == null) {
                completionHandler.handle((Object)Future.succeededFuture());
            } else {
                String p = this.portal;
                this.portal = null;
                this.result = null;
                this.ps.closePortal(p, completionHandler);
            }
        }
    }
}

