/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.impl;

import io.reactiverse.pgclient.PgConnection;
import io.reactiverse.pgclient.PgPool;
import io.reactiverse.pgclient.PgPoolOptions;
import io.reactiverse.pgclient.PgTransaction;
import io.reactiverse.pgclient.impl.CommandBase;
import io.reactiverse.pgclient.impl.CommandResponse;
import io.reactiverse.pgclient.impl.CommandScheduler;
import io.reactiverse.pgclient.impl.Connection;
import io.reactiverse.pgclient.impl.ConnectionPool;
import io.reactiverse.pgclient.impl.PgClientBase;
import io.reactiverse.pgclient.impl.PgConnectionFactory;
import io.reactiverse.pgclient.impl.PgConnectionImpl;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;

public class PgPoolImpl
extends PgClientBase<PgPoolImpl>
implements PgPool {
    private final Context context;
    private final PgConnectionFactory factory;
    private final ConnectionPool pool;
    private final boolean closeVertx;

    public PgPoolImpl(Vertx vertx, boolean closeVertx, PgPoolOptions options) {
        int maxSize = options.getMaxSize();
        if (maxSize < 1) {
            throw new IllegalArgumentException("Pool max size must be > 0");
        }
        if (options.isUsingDomainSocket() && !vertx.isNativeTransportEnabled()) {
            throw new VertxException("Native transport is not available");
        }
        this.context = vertx.getOrCreateContext();
        this.factory = new PgConnectionFactory(this.context, Vertx.currentContext() != null, options);
        this.pool = new ConnectionPool(this.factory::create, maxSize, options.getMaxWaitQueueSize());
        this.closeVertx = closeVertx;
    }

    @Override
    public void getConnection(Handler<AsyncResult<PgConnection>> handler) {
        Context current = Vertx.currentContext();
        if (current == this.context) {
            this.pool.acquire(new ConnectionWaiter(handler));
        } else {
            this.context.runOnContext(v -> this.getConnection(handler));
        }
    }

    @Override
    public void begin(Handler<AsyncResult<PgTransaction>> handler) {
        this.getConnection((Handler<AsyncResult<PgConnection>>)((Handler)ar -> {
            if (ar.succeeded()) {
                PgConnectionImpl conn = (PgConnectionImpl)ar.result();
                PgTransaction tx = conn.begin(true);
                handler.handle((Object)Future.succeededFuture((Object)tx));
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }));
    }

    @Override
    public <R> void schedule(final CommandBase<R> cmd, final Handler<? super CommandResponse<R>> handler) {
        Context current = Vertx.currentContext();
        if (current == this.context) {
            this.pool.acquire(new CommandWaiter(){

                @Override
                protected void onSuccess(final Connection conn) {
                    cmd.handler = ar -> {
                        ar.scheduler = new CommandScheduler(){

                            @Override
                            public <R> void schedule(CommandBase<R> cmd, Handler<? super CommandResponse<R>> handler) {
                                cmd.handler = cr -> {
                                    cr.scheduler = this;
                                    handler.handle(cr);
                                };
                                conn.schedule(cmd);
                            }
                        };
                        handler.handle(ar);
                    };
                    conn.schedule(cmd);
                    conn.close(this);
                }

                @Override
                protected void onFailure(Throwable cause) {
                    cmd.handler = handler;
                    cmd.fail(cause);
                }
            });
        } else {
            this.context.runOnContext(v -> this.schedule(cmd, handler));
        }
    }

    @Override
    public void close() {
        Context current = Vertx.currentContext();
        if (current == this.context) {
            this.pool.close();
            this.factory.close();
            if (this.closeVertx) {
                this.context.owner().close();
            }
        } else {
            this.context.runOnContext(v -> this.close());
        }
    }

    private class ConnectionWaiter
    implements Handler<AsyncResult<Connection>> {
        private final Handler<AsyncResult<PgConnection>> handler;

        private ConnectionWaiter(Handler<AsyncResult<PgConnection>> handler) {
            this.handler = handler;
        }

        public void handle(AsyncResult<Connection> ar) {
            if (ar.succeeded()) {
                Connection conn = (Connection)ar.result();
                PgConnectionImpl holder = new PgConnectionImpl(PgPoolImpl.this.factory, PgPoolImpl.this.context, conn);
                conn.init(holder);
                this.handler.handle((Object)Future.succeededFuture((Object)holder));
            } else {
                this.handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }
    }

    private abstract class CommandWaiter
    implements Connection.Holder,
    Handler<AsyncResult<Connection>> {
        private Connection conn;

        private CommandWaiter() {
        }

        protected abstract void onSuccess(Connection var1);

        protected abstract void onFailure(Throwable var1);

        @Override
        public void handleNotification(int processId, String channel, String payload) {
        }

        public void handle(AsyncResult<Connection> ar) {
            if (ar.succeeded()) {
                Connection conn;
                this.conn = conn = (Connection)ar.result();
                conn.init(this);
                this.onSuccess(conn);
            } else {
                this.onFailure(ar.cause());
            }
        }

        @Override
        public void handleClosed() {
        }

        @Override
        public void handleException(Throwable err) {
        }

        @Override
        public Connection connection() {
            return this.conn;
        }
    }
}

