/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.impl;

import io.reactiverse.pgclient.PgCursor;
import io.reactiverse.pgclient.PgPreparedQuery;
import io.reactiverse.pgclient.PgResult;
import io.reactiverse.pgclient.PgRowSet;
import io.reactiverse.pgclient.PgStream;
import io.reactiverse.pgclient.Row;
import io.reactiverse.pgclient.Tuple;
import io.reactiverse.pgclient.impl.ClosePortalCommand;
import io.reactiverse.pgclient.impl.CloseStatementCommand;
import io.reactiverse.pgclient.impl.Connection;
import io.reactiverse.pgclient.impl.ExtendedBatchQueryCommand;
import io.reactiverse.pgclient.impl.ExtendedQueryCommand;
import io.reactiverse.pgclient.impl.PgCursorImpl;
import io.reactiverse.pgclient.impl.PgResultBase;
import io.reactiverse.pgclient.impl.PgResultBuilder;
import io.reactiverse.pgclient.impl.PgResultImpl;
import io.reactiverse.pgclient.impl.PgRowSetImpl;
import io.reactiverse.pgclient.impl.PgStreamImpl;
import io.reactiverse.pgclient.impl.PreparedStatement;
import io.reactiverse.pgclient.impl.QueryResultHandler;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collector;

class PgPreparedQueryImpl
implements PgPreparedQuery {
    private final Connection conn;
    private final Context context;
    private final PreparedStatement ps;
    private final AtomicBoolean closed = new AtomicBoolean();

    PgPreparedQueryImpl(Connection conn, Context context, PreparedStatement ps) {
        this.conn = conn;
        this.context = context;
        this.ps = ps;
    }

    @Override
    public PgPreparedQuery execute(Tuple args, Handler<AsyncResult<PgRowSet>> handler) {
        return this.execute(args, false, PgRowSetImpl.FACTORY, PgRowSetImpl.COLLECTOR, handler);
    }

    @Override
    public <R> PgPreparedQuery execute(Tuple args, Collector<Row, ?, R> collector, Handler<AsyncResult<PgResult<R>>> handler) {
        return this.execute(args, true, PgResultImpl::new, collector, handler);
    }

    private <R1, R2 extends PgResultBase<R1, R2>, R3 extends PgResult<R1>> PgPreparedQuery execute(Tuple args, boolean singleton, Function<R1, R2> factory, Collector<Row, ?, R1> collector, Handler<AsyncResult<R3>> handler) {
        PgResultBuilder<R1, R2, R3> b = new PgResultBuilder<R1, R2, R3>(factory, handler);
        return this.execute(args, 0, null, false, singleton, collector, b, b);
    }

    <A, R> PgPreparedQuery execute(Tuple args, int fetch, String portal, boolean suspended, boolean singleton, Collector<Row, A, R> collector, QueryResultHandler<R> resultHandler, Handler<AsyncResult<Boolean>> handler) {
        if (this.context == Vertx.currentContext()) {
            String msg = this.ps.prepare((List)((Object)args));
            if (msg != null) {
                handler.handle((Object)Future.failedFuture((String)msg));
            } else {
                ExtendedQueryCommand<R> cmd = new ExtendedQueryCommand<R>(this.ps, args, fetch, portal, suspended, singleton, collector, resultHandler);
                cmd.handler = handler;
                this.conn.schedule(cmd);
            }
        } else {
            this.context.runOnContext(v -> this.execute(args, fetch, portal, suspended, singleton, collector, resultHandler, handler));
        }
        return this;
    }

    @Override
    public PgCursor cursor(Tuple args) {
        String msg = this.ps.prepare((List)((Object)args));
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        return new PgCursorImpl(this, args);
    }

    @Override
    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public PgPreparedQuery batch(List<Tuple> argsList, Handler<AsyncResult<PgRowSet>> handler) {
        return this.batch(argsList, false, PgRowSetImpl.FACTORY, PgRowSetImpl.COLLECTOR, handler);
    }

    @Override
    public <R> PgPreparedQuery batch(List<Tuple> argsList, Collector<Row, ?, R> collector, Handler<AsyncResult<PgResult<R>>> handler) {
        return this.batch(argsList, true, PgResultImpl::new, collector, handler);
    }

    private <R1, R2 extends PgResultBase<R1, R2>, R3 extends PgResult<R1>> PgPreparedQuery batch(List<Tuple> argsList, boolean singleton, Function<R1, R2> factory, Collector<Row, ?, R1> collector, Handler<AsyncResult<R3>> handler) {
        for (Tuple args : argsList) {
            String msg = this.ps.prepare((List)((Object)args));
            if (msg == null) continue;
            handler.handle((Object)Future.failedFuture((String)msg));
            return this;
        }
        PgResultBuilder<R1, R2, R3> b = new PgResultBuilder<R1, R2, R3>(factory, handler);
        ExtendedBatchQueryCommand<R1> cmd = new ExtendedBatchQueryCommand<R1>(this.ps, argsList, singleton, collector, b);
        cmd.handler = b;
        this.conn.schedule(cmd);
        return this;
    }

    @Override
    public PgStream<Row> createStream(int fetch, Tuple args) {
        return new PgStreamImpl(this, fetch, args);
    }

    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        if (this.closed.compareAndSet(false, true)) {
            CloseStatementCommand cmd = new CloseStatementCommand();
            cmd.handler = completionHandler;
            this.conn.schedule(cmd);
        } else {
            completionHandler.handle((Object)Future.failedFuture((String)"Already closed"));
        }
    }

    void closePortal(String portal, Handler<AsyncResult<Void>> handler) {
        ClosePortalCommand cmd = new ClosePortalCommand(portal);
        cmd.handler = handler;
        this.conn.schedule(cmd);
    }
}

