/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.impl;

import io.reactiverse.pgclient.PgResult;
import io.reactiverse.pgclient.impl.PgResultBase;
import io.reactiverse.pgclient.impl.QueryResultHandler;
import io.reactiverse.pgclient.impl.codec.decoder.RowDescription;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.function.Function;

public class PgResultBuilder<T, R extends PgResultBase<T, R>, L extends PgResult<T>>
implements QueryResultHandler<T>,
Handler<AsyncResult<Boolean>> {
    private final Handler<AsyncResult<L>> handler;
    private final Function<T, R> factory;
    private R first;
    private boolean suspended;

    PgResultBuilder(Function<T, R> factory, Handler<AsyncResult<L>> handler) {
        this.factory = factory;
        this.handler = handler;
    }

    @Override
    public void handleResult(int updatedCount, int size, RowDescription desc, T result) {
        PgResultBase r = (PgResultBase)this.factory.apply(result);
        r.updated = updatedCount;
        r.size = size;
        r.columnNames = desc != null ? desc.columnNames() : null;
        this.handleResult(r);
    }

    private void handleResult(R result) {
        if (this.first == null) {
            this.first = result;
        } else {
            R h = this.first;
            while (((PgResultBase)h).next != null) {
                h = ((PgResultBase)h).next;
            }
            ((PgResultBase)h).next = result;
        }
    }

    public void handle(AsyncResult<Boolean> res) {
        this.suspended = res.succeeded() && (Boolean)res.result() != false;
        this.handler.handle((Object)res.map(this.first));
    }

    public boolean isSuspended() {
        return this.suspended;
    }
}

