/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.impl;

import io.reactiverse.pgclient.PgException;
import io.reactiverse.pgclient.impl.CommandBase;
import io.reactiverse.pgclient.impl.PreparedStatement;
import io.reactiverse.pgclient.impl.SocketConnection;
import io.reactiverse.pgclient.impl.codec.TxStatus;
import io.reactiverse.pgclient.impl.codec.decoder.ErrorResponse;
import io.reactiverse.pgclient.impl.codec.decoder.ParameterDescription;
import io.reactiverse.pgclient.impl.codec.decoder.RowDescription;
import io.reactiverse.pgclient.impl.codec.encoder.Describe;
import io.reactiverse.pgclient.impl.codec.encoder.MessageEncoder;
import io.reactiverse.pgclient.impl.codec.encoder.Parse;

public class PrepareStatementCommand
extends CommandBase<PreparedStatement> {
    final String sql;
    long statement;
    SocketConnection.CachedPreparedStatement cached;
    private ParameterDescription parameterDesc;
    private RowDescription rowDesc;

    PrepareStatementCommand(String sql) {
        this.sql = sql;
    }

    @Override
    void exec(MessageEncoder out) {
        out.writeParse(new Parse(this.sql, this.statement));
        out.writeDescribe(new Describe(this.statement, null));
        out.writeSync();
    }

    @Override
    public void handleParseComplete() {
    }

    @Override
    public void handleParameterDescription(ParameterDescription parameterDesc) {
        this.parameterDesc = parameterDesc;
    }

    @Override
    public void handleRowDescription(RowDescription rowDesc) {
        this.rowDesc = rowDesc;
    }

    @Override
    public void handleNoData() {
    }

    @Override
    public void handleErrorResponse(ErrorResponse errorResponse) {
        this.failure = new PgException(errorResponse);
    }

    @Override
    public void handleReadyForQuery(TxStatus txStatus) {
        this.result = new PreparedStatement(this.sql, this.statement, this.parameterDesc, this.rowDesc);
        super.handleReadyForQuery(txStatus);
    }
}

