/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.impl;

import io.reactiverse.pgclient.PgException;
import io.reactiverse.pgclient.Row;
import io.reactiverse.pgclient.impl.CommandBase;
import io.reactiverse.pgclient.impl.QueryResultHandler;
import io.reactiverse.pgclient.impl.RowResultDecoder;
import io.reactiverse.pgclient.impl.codec.decoder.ErrorResponse;
import io.reactiverse.pgclient.impl.codec.decoder.RowDescription;
import java.util.stream.Collector;

public abstract class QueryCommandBase<T>
extends CommandBase<Boolean> {
    public RowResultDecoder<?, T> decoder;
    final QueryResultHandler<T> resultHandler;
    final Collector<Row, ?, T> collector;

    QueryCommandBase(Collector<Row, ?, T> collector, QueryResultHandler<T> resultHandler) {
        this.resultHandler = resultHandler;
        this.collector = collector;
    }

    abstract String sql();

    @Override
    public void handleCommandComplete(int updated) {
        int size;
        RowDescription desc;
        T result;
        this.result = false;
        if (this.decoder != null) {
            result = this.decoder.complete();
            desc = this.decoder.description();
            size = this.decoder.size();
            this.decoder.reset();
        } else {
            result = QueryCommandBase.emptyResult(this.collector);
            size = 0;
            desc = null;
        }
        this.resultHandler.handleResult(updated, size, desc, result);
    }

    @Override
    public void handleErrorResponse(ErrorResponse errorResponse) {
        this.failure = new PgException(errorResponse);
    }

    private static <A, T> T emptyResult(Collector<Row, A, T> collector) {
        return collector.finisher().apply(collector.supplier().get());
    }
}

