/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.impl;

import io.netty.buffer.ByteBuf;
import io.reactiverse.pgclient.Row;
import io.reactiverse.pgclient.impl.RowImpl;
import io.reactiverse.pgclient.impl.codec.ColumnDesc;
import io.reactiverse.pgclient.impl.codec.DataFormat;
import io.reactiverse.pgclient.impl.codec.DataTypeCodec;
import io.reactiverse.pgclient.impl.codec.decoder.RowDecoder;
import io.reactiverse.pgclient.impl.codec.decoder.RowDescription;
import java.util.function.BiConsumer;
import java.util.stream.Collector;

public class RowResultDecoder<C, R>
implements RowDecoder {
    private final Collector<Row, C, R> collector;
    private final boolean singleton;
    private final BiConsumer<C, Row> accumulator;
    private RowDescription desc;
    private int size;
    private C container;
    private Row row;

    RowResultDecoder(Collector<Row, C, R> collector, boolean singleton, RowDescription desc) {
        this.collector = collector;
        this.singleton = singleton;
        this.accumulator = collector.accumulator();
        this.desc = desc;
    }

    public RowDescription description() {
        return this.desc;
    }

    public int size() {
        return this.size;
    }

    @Override
    public void decodeRow(int len, ByteBuf in) {
        if (this.container == null) {
            this.container = this.collector.supplier().get();
        }
        if (this.singleton) {
            if (this.row == null) {
                this.row = new RowImpl(this.desc);
            } else {
                this.row.clear();
            }
        } else {
            this.row = new RowImpl(this.desc);
        }
        RowImpl row = new RowImpl(this.desc);
        for (int c = 0; c < len; ++c) {
            int length = in.readInt();
            Object decoded = null;
            if (length != -1) {
                ColumnDesc columnDesc = this.desc.columns()[c];
                decoded = columnDesc.getDataFormat() == DataFormat.BINARY ? DataTypeCodec.decodeBinary(columnDesc.getDataType(), in.readerIndex(), length, in) : DataTypeCodec.decodeText(columnDesc.getDataType(), in.readerIndex(), length, in);
                in.skipBytes(length);
            }
            row.addValue(decoded);
        }
        this.accumulator.accept(this.container, row);
        ++this.size;
    }

    R complete() {
        if (this.container == null) {
            this.container = this.collector.supplier().get();
        }
        return this.collector.finisher().apply(this.container);
    }

    void reset() {
        this.container = null;
        this.size = 0;
    }
}

