/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.impl.codec.decoder;

import io.reactiverse.pgclient.impl.codec.DataType;
import io.reactiverse.pgclient.impl.codec.DataTypeCodec;
import io.reactiverse.pgclient.impl.codec.util.Util;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class ParameterDescription {
    private final DataType[] paramDataTypes;

    public ParameterDescription(DataType[] paramDataTypes) {
        this.paramDataTypes = paramDataTypes;
    }

    public DataType[] getParamDataTypes() {
        return this.paramDataTypes;
    }

    public String prepare(List<Object> values) {
        if (values.size() != this.paramDataTypes.length) {
            return this.buildReport(values);
        }
        for (int i = 0; i < this.paramDataTypes.length; ++i) {
            DataType paramDataType = this.paramDataTypes[i];
            Object value = values.get(i);
            Object val = DataTypeCodec.prepare(paramDataType, value);
            if (val == value) continue;
            if (val == DataTypeCodec.REFUSED_SENTINEL) {
                return this.buildReport(values);
            }
            values.set(i, val);
        }
        return null;
    }

    private String buildReport(List<Object> values) {
        return Util.buildInvalidArgsError(values.stream(), Stream.of(this.paramDataTypes).map(type -> type.decodingType));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterDescription that = (ParameterDescription)o;
        return Arrays.equals((Object[])this.paramDataTypes, (Object[])that.paramDataTypes);
    }

    public int hashCode() {
        return Arrays.hashCode((Object[])this.paramDataTypes);
    }

    public String toString() {
        return "ParameterDescription{paramDataTypes=" + Arrays.toString((Object[])this.paramDataTypes) + '}';
    }
}

