/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.impl.codec.decoder;

import io.reactiverse.pgclient.impl.codec.ColumnDesc;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RowDescription {
    private final ColumnDesc[] columns;
    private final List<String> columnNames;

    public RowDescription(ColumnDesc[] columns) {
        this.columns = columns;
        this.columnNames = Collections.unmodifiableList(Stream.of(columns).map(ColumnDesc::getName).collect(Collectors.toList()));
    }

    public int columnIndex(String columnName) {
        if (columnName == null) {
            throw new NullPointerException("Column name must not be null");
        }
        return this.columnNames.indexOf(columnName);
    }

    public ColumnDesc[] columns() {
        return this.columns;
    }

    public List<String> columnNames() {
        return this.columnNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowDescription that = (RowDescription)o;
        return Arrays.equals(this.columns, that.columns);
    }

    public int hashCode() {
        return Arrays.hashCode(this.columns);
    }

    public String toString() {
        return "RowDescription{columns=" + Arrays.toString(this.columns) + '}';
    }
}

