/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.pgclient.impl.codec.encoder;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.reactiverse.pgclient.impl.codec.ColumnDesc;
import io.reactiverse.pgclient.impl.codec.DataType;
import io.reactiverse.pgclient.impl.codec.DataTypeCodec;
import io.reactiverse.pgclient.impl.codec.encoder.Bind;
import io.reactiverse.pgclient.impl.codec.encoder.Describe;
import io.reactiverse.pgclient.impl.codec.encoder.Parse;
import io.reactiverse.pgclient.impl.codec.encoder.PasswordMessage;
import io.reactiverse.pgclient.impl.codec.encoder.Query;
import io.reactiverse.pgclient.impl.codec.encoder.StartupMessage;
import io.reactiverse.pgclient.impl.codec.util.Util;
import java.nio.charset.StandardCharsets;
import java.util.List;

public final class MessageEncoder {
    private static final byte PASSWORD_MESSAGE = 112;
    private static final byte QUERY = 81;
    private static final byte TERMINATE = 88;
    private static final byte PARSE = 80;
    private static final byte BIND = 66;
    private static final byte DESCRIBE = 68;
    private static final byte EXECUTE = 69;
    private static final byte CLOSE = 67;
    private static final byte SYNC = 83;
    private final ChannelHandlerContext ctx;
    private ByteBuf out;

    public MessageEncoder(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    public void flush() {
        if (this.out != null) {
            ByteBuf buff = this.out;
            this.out = null;
            this.ctx.writeAndFlush((Object)buff);
        }
    }

    public void writeTerminate() {
        this.ensureBuffer();
        this.out.writeByte(88);
        this.out.writeInt(4);
    }

    public void writeSync() {
        this.ensureBuffer();
        this.out.writeByte(83);
        this.out.writeInt(4);
    }

    public void writeClosePortal(String portal) {
        this.ensureBuffer();
        int pos = this.out.writerIndex();
        this.out.writeByte(67);
        this.out.writeInt(0);
        this.out.writeByte(80);
        Util.writeCStringUTF8(this.out, portal);
        this.out.setInt(pos + 1, this.out.writerIndex() - pos - 1);
    }

    public void writeStartupMessage(StartupMessage msg) {
        this.ensureBuffer();
        int pos = this.out.writerIndex();
        this.out.writeInt(0);
        this.out.writeShort(3);
        this.out.writeShort(0);
        Util.writeCString(this.out, StartupMessage.BUFF_USER);
        Util.writeCStringUTF8(this.out, msg.username);
        Util.writeCString(this.out, StartupMessage.BUFF_DATABASE);
        Util.writeCStringUTF8(this.out, msg.database);
        Util.writeCString(this.out, StartupMessage.BUFF_APPLICATION_NAME);
        Util.writeCString(this.out, StartupMessage.BUFF_VERTX_PG_CLIENT);
        Util.writeCString(this.out, StartupMessage.BUFF_CLIENT_ENCODING);
        Util.writeCString(this.out, StartupMessage.BUFF_UTF8);
        Util.writeCString(this.out, StartupMessage.BUFF_DATE_STYLE);
        Util.writeCString(this.out, StartupMessage.BUFF_ISO);
        Util.writeCString(this.out, StartupMessage.BUFF_INTERVAL_STYLE);
        Util.writeCString(this.out, StartupMessage.BUFF_INTERVAL_STYLE_TYPE);
        Util.writeCString(this.out, StartupMessage.BUFF_EXTRA_FLOAT_DIGITS);
        Util.writeCString(this.out, StartupMessage.BUFF_2);
        this.out.writeByte(0);
        this.out.setInt(pos, this.out.writerIndex() - pos);
    }

    public void writePasswordMessage(PasswordMessage msg) {
        this.ensureBuffer();
        int pos = this.out.writerIndex();
        this.out.writeByte(112);
        this.out.writeInt(0);
        Util.writeCStringUTF8(this.out, msg.hash);
        this.out.setInt(pos + 1, this.out.writerIndex() - pos - 1);
    }

    public void writeQuery(Query query) {
        this.ensureBuffer();
        int pos = this.out.writerIndex();
        this.out.writeByte(81);
        this.out.writeInt(0);
        Util.writeCStringUTF8(this.out, query.sql);
        this.out.setInt(pos + 1, this.out.writerIndex() - pos - 1);
    }

    public void writeDescribe(Describe describe) {
        this.ensureBuffer();
        int pos = this.out.writerIndex();
        this.out.writeByte(68);
        this.out.writeInt(0);
        if (describe.statement != 0L) {
            this.out.writeByte(83);
            this.out.writeLong(describe.statement);
        } else if (describe.portal != null) {
            this.out.writeByte(80);
            Util.writeCStringUTF8(this.out, describe.portal);
        } else {
            this.out.writeByte(83);
            Util.writeCStringUTF8(this.out, "");
        }
        this.out.setInt(pos + 1, this.out.writerIndex() - pos - 1);
    }

    public void writeParse(Parse parse) {
        this.ensureBuffer();
        int pos = this.out.writerIndex();
        this.out.writeByte(80);
        this.out.writeInt(0);
        if (parse.statement == 0L) {
            this.out.writeByte(0);
        } else {
            this.out.writeLong(parse.statement);
        }
        Util.writeCStringUTF8(this.out, parse.query);
        this.out.writeShort(0);
        this.out.setInt(pos + 1, this.out.writerIndex() - pos - 1);
    }

    public void writeExecute(String portal, int rowCount) {
        this.ensureBuffer();
        int pos = this.out.writerIndex();
        this.out.writeByte(69);
        this.out.writeInt(0);
        if (portal != null) {
            this.out.writeCharSequence((CharSequence)portal, StandardCharsets.UTF_8);
        }
        this.out.writeByte(0);
        this.out.writeInt(rowCount);
        this.out.setInt(pos + 1, this.out.writerIndex() - pos - 1);
    }

    public void writeBind(Bind bind, String portal, List<Object> paramValues) {
        int c;
        this.ensureBuffer();
        int pos = this.out.writerIndex();
        this.out.writeByte(66);
        this.out.writeInt(0);
        if (portal != null) {
            this.out.writeCharSequence((CharSequence)portal, StandardCharsets.UTF_8);
        }
        this.out.writeByte(0);
        if (bind.statement == 0L) {
            this.out.writeByte(0);
        } else {
            this.out.writeLong(bind.statement);
        }
        int paramLen = paramValues.size();
        this.out.writeShort(paramLen);
        for (c = 0; c < paramLen; ++c) {
            this.out.writeShort(bind.paramTypes[c].supportsBinary ? 1 : 0);
        }
        this.out.writeShort(paramLen);
        for (c = 0; c < paramLen; ++c) {
            Object param = paramValues.get(c);
            if (param == null) {
                this.out.writeInt(-1);
                continue;
            }
            DataType dataType = bind.paramTypes[c];
            if (dataType.supportsBinary) {
                int idx = this.out.writerIndex();
                this.out.writeInt(0);
                DataTypeCodec.encodeBinary(dataType, param, this.out);
                this.out.setInt(idx, this.out.writerIndex() - idx - 4);
                continue;
            }
            DataTypeCodec.encodeText(dataType, param, this.out);
        }
        if (bind.resultColumns.length > 0) {
            this.out.writeShort(bind.resultColumns.length);
            for (ColumnDesc resultColumn : bind.resultColumns) {
                this.out.writeShort(resultColumn.getDataType().supportsBinary ? 1 : 0);
            }
        } else {
            this.out.writeShort(1);
            this.out.writeShort(1);
        }
        this.out.setInt(pos + 1, this.out.writerIndex() - pos - 1);
    }

    private void ensureBuffer() {
        if (this.out == null) {
            this.out = this.ctx.alloc().ioBuffer();
        }
    }
}

