/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module reactive-pg-client-js/pg_iterator */
var utils = require('vertx-js/util/utils');
var Row = require('reactive-pg-client-js/row');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JPgIterator = Java.type('io.reactiverse.pgclient.PgIterator');

/**
 An iterator for processing postgres items synchronously.

 @class
*/
var PgIterator = function(j_val) {

  var j_pgIterator = j_val;
  var that = this;

  var __super_hasNext = this.hasNext;
  var __super_next = this.next;
  /**

   @public

   @return {boolean}
   */
  this.hasNext =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_pgIterator["hasNext()"]() ;
    } else if (typeof __super_hasNext != 'undefined') {
      return __super_hasNext.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Row}
   */
  this.next =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Row, j_pgIterator["next()"]()) ;
    } else if (typeof __super_next != 'undefined') {
      return __super_next.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_pgIterator;
};

PgIterator._jclass = utils.getJavaClass("io.reactiverse.pgclient.PgIterator");
PgIterator._jtype = {accept: function(obj) {
    return PgIterator._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(PgIterator.prototype, {});
    PgIterator.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
PgIterator._create = function(jdel) {var obj = Object.create(PgIterator.prototype, {});
  PgIterator.apply(obj, arguments);
  return obj;
}
module.exports = PgIterator;