/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module reactive-pg-client-js/pg_prepared_query */
var utils = require('vertx-js/util/utils');
var Row = require('reactive-pg-client-js/row');
var Tuple = require('reactive-pg-client-js/tuple');
var PgCursor = require('reactive-pg-client-js/pg_cursor');
var PgRowSet = require('reactive-pg-client-js/pg_row_set');
var PgStream = require('reactive-pg-client-js/pg_stream');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JPgPreparedQuery = Java.type('io.reactiverse.pgclient.PgPreparedQuery');

/**
 A prepared query.

 @class
*/
var PgPreparedQuery = function(j_val) {

  var j_pgPreparedQuery = j_val;
  var that = this;

  var __super_execute = this.execute;
  var __super_execute = this.execute;
  var __super_cursor = this.cursor;
  var __super_cursor = this.cursor;
  var __super_createStream = this.createStream;
  var __super_batch = this.batch;
  var __super_close = this.close;
  var __super_close = this.close;
  /**
   Create a cursor with the provided <code>arguments</code>.

   @public
   @param args {Tuple} the list of arguments 
   @param handler {function} 
   @return {PgPreparedQuery} the query
   */
  this.execute =  function() {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_pgPreparedQuery["execute(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnVertxGen(PgRowSet, ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'function') {
      j_pgPreparedQuery["execute(io.reactiverse.pgclient.Tuple,io.vertx.core.Handler)"](__args[0]._jdel, function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(PgRowSet, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_execute != 'undefined') {
      return __super_execute.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Create a cursor with the provided <code>arguments</code>.

   @public
   @param args {Tuple} the list of arguments 
   @return {PgCursor} the query
   */
  this.cursor =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(PgCursor, j_pgPreparedQuery["cursor()"]()) ;
    } else if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      return utils.convReturnVertxGen(PgCursor, j_pgPreparedQuery["cursor(io.reactiverse.pgclient.Tuple)"](__args[0]._jdel)) ;
    } else if (typeof __super_cursor != 'undefined') {
      return __super_cursor.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Execute the prepared query with a cursor and createStream the result. The createStream opens a cursor
   with a <code>fetch</code> size to fetch the results.
   <p/>
   Note: this requires to be in a transaction, since cursors require it.

   @public
   @param fetch {number} the cursor fetch size 
   @param args {Tuple} the prepared query arguments 
   @return {PgStream} the createStream
   */
  this.createStream =  function(fetch, args) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='number' && typeof __args[1] === 'object' && __args[1]._jdel) {
      return utils.convReturnVertxGen(PgStream, j_pgPreparedQuery["createStream(int,io.reactiverse.pgclient.Tuple)"](__args[0], __args[1]._jdel), Row._jtype) ;
    } else if (typeof __super_createStream != 'undefined') {
      return __super_createStream.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Execute a batch.

   @public
   @param argsList {Array.<Tuple>} the list of tuple for the batch 
   @param handler {function} 
   @return {PgPreparedQuery} the createBatch
   */
  this.batch =  function(argsList, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_pgPreparedQuery["batch(java.util.List,io.vertx.core.Handler)"](utils.convParamListVertxGen(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(PgRowSet, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_batch != 'undefined') {
      return __super_batch.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Like {@link PgPreparedQuery#close} but notifies the <code>completionHandler</code> when it's closed.

   @public
   @param completionHandler {function} 
   */
  this.close =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_pgPreparedQuery["close()"]();
    } else if (__args.length === 1 && typeof __args[0] === 'function') {
      j_pgPreparedQuery["close(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](null, null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_close != 'undefined') {
      return __super_close.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_pgPreparedQuery;
};

PgPreparedQuery._jclass = utils.getJavaClass("io.reactiverse.pgclient.PgPreparedQuery");
PgPreparedQuery._jtype = {accept: function(obj) {
    return PgPreparedQuery._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(PgPreparedQuery.prototype, {});
    PgPreparedQuery.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
PgPreparedQuery._create = function(jdel) {var obj = Object.create(PgPreparedQuery.prototype, {});
  PgPreparedQuery.apply(obj, arguments);
  return obj;
}
module.exports = PgPreparedQuery;