/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module reactive-pg-client-js/pg_result */
var utils = require('vertx-js/util/utils');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JPgResult = Java.type('io.reactiverse.pgclient.PgResult');

/**
 Represents the result of an operation on database.
 @class
*/
var PgResult = function(j_val, j_arg_0) {

  var j_pgResult = j_val;
  var that = this;
  var j_T = typeof j_arg_0 !== 'undefined' ? j_arg_0 : utils.unknown_jtype;
  var __super_rowCount = this.rowCount;
  var __super_columnsNames = this.columnsNames;
  var __super_size = this.size;
  var __super_value = this.value;
  var __super_next = this.next;
  /**
   Get the number of the affected rows in the operation to this PgResult.
   <p/>
   The meaning depends on the executed statement:
   <ul>
     <li>INSERT: the number of rows inserted</li>
     <li>DELETE: the number of rows deleted</li>
     <li>UPDATE: the number of rows updated</li>
     <li>SELECT: the number of rows retrieved</li>
   </ul>

   @public

   @return {number} the count of affected rows.
   */
  this.rowCount =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_pgResult["rowCount()"]() ;
    } else if (typeof __super_rowCount != 'undefined') {
      return __super_rowCount.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get the names of columns in the PgResult.

   @public

   @return {Array.<string>} the list of names of columns.
   */
  this.columnsNames =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_pgResult["columnsNames()"]() ;
    } else if (typeof __super_columnsNames != 'undefined') {
      return __super_columnsNames.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get the number of rows in the PgResult.

   @public

   @return {number} the count of rows.
   */
  this.size =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_pgResult["size()"]() ;
    } else if (typeof __super_size != 'undefined') {
      return __super_size.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get the result value.

   @public

   @return {Object} the result
   */
  this.value =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_T.wrap(j_pgResult["value()"]()) ;
    } else if (typeof __super_value != 'undefined') {
      return __super_value.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Return the next available result or <code>null</code>, e.g for a simple query that executed multiple queries or for
   a batch result.

   @public

   @return {PgResult} the next available result or <code>null</code> if none is available
   */
  this.next =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(PgResult, j_pgResult["next()"](), undefined) ;
    } else if (typeof __super_next != 'undefined') {
      return __super_next.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_pgResult;
};

PgResult._jclass = utils.getJavaClass("io.reactiverse.pgclient.PgResult");
PgResult._jtype = {accept: function(obj) {
    return PgResult._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(PgResult.prototype, {});
    PgResult.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
PgResult._create = function(jdel) {var obj = Object.create(PgResult.prototype, {});
  PgResult.apply(obj, arguments);
  return obj;
}
module.exports = PgResult;