/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module reactive-pg-client-js/pg_row_set */
var utils = require('vertx-js/util/utils');
var PgIterator = require('reactive-pg-client-js/pg_iterator');
var Row = require('reactive-pg-client-js/row');
var PgResult = require('reactive-pg-client-js/pg_result');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JPgRowSet = Java.type('io.reactiverse.pgclient.PgRowSet');

/**
 A set of rows.

 @class
*/
var PgRowSet = function(j_val) {

  var j_pgRowSet = j_val;
  var that = this;
  PgResult.call(this, j_val, PgRowSet._jtype);

  var __super_value = this.value;
  var __super_iterator = this.iterator;
  var __super_next = this.next;
  /**
   Get the result value.

   @public

   @return {PgRowSet} the result
   */
  this.value =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(PgRowSet, j_pgRowSet["value()"]()) ;
    } else if (typeof __super_value != 'undefined') {
      return __super_value.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {PgIterator}
   */
  this.iterator =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(PgIterator, j_pgRowSet["iterator()"]()) ;
    } else if (typeof __super_iterator != 'undefined') {
      return __super_iterator.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {PgRowSet}
   */
  this.next =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(PgRowSet, j_pgRowSet["next()"]()) ;
    } else if (typeof __super_next != 'undefined') {
      return __super_next.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_pgRowSet;
};

PgRowSet._jclass = utils.getJavaClass("io.reactiverse.pgclient.PgRowSet");
PgRowSet._jtype = {accept: function(obj) {
    return PgRowSet._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(PgRowSet.prototype, {});
    PgRowSet.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
PgRowSet._create = function(jdel) {var obj = Object.create(PgRowSet.prototype, {});
  PgRowSet.apply(obj, arguments);
  return obj;
}
module.exports = PgRowSet;