/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module reactive-pg-client-js/pg_transaction */
var utils = require('vertx-js/util/utils');
var PgClient = require('reactive-pg-client-js/pg_client');
var Tuple = require('reactive-pg-client-js/tuple');
var PgPreparedQuery = require('reactive-pg-client-js/pg_prepared_query');
var PgRowSet = require('reactive-pg-client-js/pg_row_set');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JPgTransaction = Java.type('io.reactiverse.pgclient.PgTransaction');

/**
 A transaction that allows to control the transaction and receive events.

 @class
*/
var PgTransaction = function(j_val) {

  var j_pgTransaction = j_val;
  var that = this;
  PgClient.call(this, j_val);

  var __super_prepare = this.prepare;
  var __super_commit = this.commit;
  var __super_commit = this.commit;
  var __super_rollback = this.rollback;
  var __super_rollback = this.rollback;
  var __super_abortHandler = this.abortHandler;
  var __super_query = this.query;
  var __super_preparedQuery = this.preparedQuery;
  var __super_preparedQuery = this.preparedQuery;
  var __super_preparedBatch = this.preparedBatch;
  var __super_close = this.close;
  /**
   Create a prepared query.

   @public
   @param sql {string} the sql 
   @param handler {function} the handler notified with the prepared query asynchronously 
   @return {PgTransaction}
   */
  this.prepare =  function(sql, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_pgTransaction["prepare(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(PgPreparedQuery, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_prepare != 'undefined') {
      return __super_prepare.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Like {@link PgTransaction#commit} with an handler to be notified when the transaction commit has completed

   @public
   @param handler {function} 
   */
  this.commit =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_pgTransaction["commit()"]();
    } else if (__args.length === 1 && typeof __args[0] === 'function') {
      j_pgTransaction["commit(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](null, null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_commit != 'undefined') {
      return __super_commit.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Like {@link PgTransaction#rollback} with an handler to be notified when the transaction rollback has completed

   @public
   @param handler {function} 
   */
  this.rollback =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_pgTransaction["rollback()"]();
    } else if (__args.length === 1 && typeof __args[0] === 'function') {
      j_pgTransaction["rollback(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](null, null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_rollback != 'undefined') {
      return __super_rollback.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set an handler to be called when the transaction is aborted.

   @public
   @param handler {function} the handler 
   @return {PgTransaction}
   */
  this.abortHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_pgTransaction["abortHandler(io.vertx.core.Handler)"](__args[0]) ;
      return that;
    } else if (typeof __super_abortHandler != 'undefined') {
      return __super_abortHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param sql {string} 
   @param handler {function} 
   @return {PgTransaction}
   */
  this.query =  function(sql, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_pgTransaction["query(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(PgRowSet, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_query != 'undefined') {
      return __super_query.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param sql {string} 
   @param arguments {Tuple} 
   @param handler {function} 
   @return {PgTransaction}
   */
  this.preparedQuery =  function() {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_pgTransaction["preparedQuery(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(PgRowSet, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'function') {
      j_pgTransaction["preparedQuery(java.lang.String,io.reactiverse.pgclient.Tuple,io.vertx.core.Handler)"](__args[0], __args[1]._jdel, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(PgRowSet, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_preparedQuery != 'undefined') {
      return __super_preparedQuery.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param sql {string} 
   @param batch {Array.<Tuple>} 
   @param handler {function} 
   @return {PgTransaction}
   */
  this.preparedBatch =  function(sql, batch, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1] instanceof Array && typeof __args[2] === 'function') {
      j_pgTransaction["preparedBatch(java.lang.String,java.util.List,io.vertx.core.Handler)"](__args[0], utils.convParamListVertxGen(__args[1]), function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(PgRowSet, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_preparedBatch != 'undefined') {
      return __super_preparedBatch.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Rollback the transaction and release the associated resources.

   @public

   */
  this.close =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_pgTransaction["close()"]();
    } else if (typeof __super_close != 'undefined') {
      return __super_close.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_pgTransaction;
};

PgTransaction._jclass = utils.getJavaClass("io.reactiverse.pgclient.PgTransaction");
PgTransaction._jtype = {accept: function(obj) {
    return PgTransaction._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(PgTransaction.prototype, {});
    PgTransaction.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
PgTransaction._create = function(jdel) {var obj = Object.create(PgTransaction.prototype, {});
  PgTransaction.apply(obj, arguments);
  return obj;
}
module.exports = PgTransaction;