/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module reactive-pg-client-js/tuple */
var utils = require('vertx-js/util/utils');
var Json = require('reactive-pg-client-js/json');
var Buffer = require('vertx-js/buffer');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JTuple = Java.type('io.reactiverse.pgclient.Tuple');
var Point = Java.type('io.reactiverse.pgclient.data.Point');
var Path = Java.type('io.reactiverse.pgclient.data.Path');
var Box = Java.type('io.reactiverse.pgclient.data.Box');
var Circle = Java.type('io.reactiverse.pgclient.data.Circle');
var Polygon = Java.type('io.reactiverse.pgclient.data.Polygon');
var Interval = Java.type('io.reactiverse.pgclient.data.Interval');
var LineSegment = Java.type('io.reactiverse.pgclient.data.LineSegment');
var Line = Java.type('io.reactiverse.pgclient.data.Line');

/**
 A general purpose tuple.

 @class
*/
var Tuple = function(j_val) {

  var j_tuple = j_val;
  var that = this;

  var __super_tuple = this.tuple;
  var __super_of = this.of;
  var __super_of = this.of;
  var __super_of = this.of;
  var __super_of = this.of;
  var __super_of = this.of;
  var __super_of = this.of;
  var __super_getBoolean = this.getBoolean;
  var __super_getValue = this.getValue;
  var __super_getShort = this.getShort;
  var __super_getInteger = this.getInteger;
  var __super_getLong = this.getLong;
  var __super_getFloat = this.getFloat;
  var __super_getDouble = this.getDouble;
  var __super_getString = this.getString;
  var __super_getJson = this.getJson;
  var __super_getPoint = this.getPoint;
  var __super_getLine = this.getLine;
  var __super_getLineSegment = this.getLineSegment;
  var __super_getBox = this.getBox;
  var __super_getPath = this.getPath;
  var __super_getPolygon = this.getPolygon;
  var __super_getCircle = this.getCircle;
  var __super_getInterval = this.getInterval;
  var __super_getBuffer = this.getBuffer;
  var __super_addBoolean = this.addBoolean;
  var __super_addValue = this.addValue;
  var __super_addShort = this.addShort;
  var __super_addInteger = this.addInteger;
  var __super_addLong = this.addLong;
  var __super_addFloat = this.addFloat;
  var __super_addDouble = this.addDouble;
  var __super_addString = this.addString;
  var __super_addJson = this.addJson;
  var __super_addBuffer = this.addBuffer;
  var __super_addPoint = this.addPoint;
  var __super_addLine = this.addLine;
  var __super_addLineSegment = this.addLineSegment;
  var __super_addBox = this.addBox;
  var __super_addPath = this.addPath;
  var __super_addPolygon = this.addPolygon;
  var __super_addCircle = this.addCircle;
  var __super_addInterval = this.addInterval;
  var __super_size = this.size;
  var __super_clear = this.clear;
  /**
   Get a boolean value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {boolean} the value or <code>null</code>
   */
  this.getBoolean =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_tuple["getBoolean(int)"](__args[0]) ;
    } else if (typeof __super_getBoolean != 'undefined') {
      return __super_getBoolean.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get an object value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {Object} the value or <code>null</code>
   */
  this.getValue =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnTypeUnknown(j_tuple["getValue(int)"](__args[0])) ;
    } else if (typeof __super_getValue != 'undefined') {
      return __super_getValue.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get a short value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {number} the value or <code>null</code>
   */
  this.getShort =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_tuple["getShort(int)"](__args[0]) ;
    } else if (typeof __super_getShort != 'undefined') {
      return __super_getShort.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get an integer value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {number} the value or <code>null</code>
   */
  this.getInteger =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_tuple["getInteger(int)"](__args[0]) ;
    } else if (typeof __super_getInteger != 'undefined') {
      return __super_getInteger.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get a long value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {number} the value or <code>null</code>
   */
  this.getLong =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnLong(j_tuple["getLong(int)"](__args[0])) ;
    } else if (typeof __super_getLong != 'undefined') {
      return __super_getLong.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get a float value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {number} the value or <code>null</code>
   */
  this.getFloat =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_tuple["getFloat(int)"](__args[0]) ;
    } else if (typeof __super_getFloat != 'undefined') {
      return __super_getFloat.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get a double value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {number} the value or <code>null</code>
   */
  this.getDouble =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_tuple["getDouble(int)"](__args[0]) ;
    } else if (typeof __super_getDouble != 'undefined') {
      return __super_getDouble.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get a string value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {string} the value or <code>null</code>
   */
  this.getString =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_tuple["getString(int)"](__args[0]) ;
    } else if (typeof __super_getString != 'undefined') {
      return __super_getString.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get a json value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {Json} the value or <code>null</code>
   */
  this.getJson =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnVertxGen(Json, j_tuple["getJson(int)"](__args[0])) ;
    } else if (typeof __super_getJson != 'undefined') {
      return __super_getJson.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get  value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {Object} the value or <code>null</code>
   */
  this.getPoint =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnDataObject(j_tuple["getPoint(int)"](__args[0])) ;
    } else if (typeof __super_getPoint != 'undefined') {
      return __super_getPoint.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get  value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {Object} the value or <code>null</code>
   */
  this.getLine =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnDataObject(j_tuple["getLine(int)"](__args[0])) ;
    } else if (typeof __super_getLine != 'undefined') {
      return __super_getLine.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get  value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {Object} the value or <code>null</code>
   */
  this.getLineSegment =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnDataObject(j_tuple["getLineSegment(int)"](__args[0])) ;
    } else if (typeof __super_getLineSegment != 'undefined') {
      return __super_getLineSegment.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get  value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {Object} the value or <code>null</code>
   */
  this.getBox =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnDataObject(j_tuple["getBox(int)"](__args[0])) ;
    } else if (typeof __super_getBox != 'undefined') {
      return __super_getBox.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get  value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {Object} the value or <code>null</code>
   */
  this.getPath =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnDataObject(j_tuple["getPath(int)"](__args[0])) ;
    } else if (typeof __super_getPath != 'undefined') {
      return __super_getPath.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get  value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {Object} the value or <code>null</code>
   */
  this.getPolygon =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnDataObject(j_tuple["getPolygon(int)"](__args[0])) ;
    } else if (typeof __super_getPolygon != 'undefined') {
      return __super_getPolygon.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get  value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {Object} the value or <code>null</code>
   */
  this.getCircle =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnDataObject(j_tuple["getCircle(int)"](__args[0])) ;
    } else if (typeof __super_getCircle != 'undefined') {
      return __super_getCircle.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get  value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {Object} the value or <code>null</code>
   */
  this.getInterval =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnDataObject(j_tuple["getInterval(int)"](__args[0])) ;
    } else if (typeof __super_getInterval != 'undefined') {
      return __super_getInterval.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get a buffer value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {Buffer} the value or <code>null</code>
   */
  this.getBuffer =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnVertxGen(Buffer, j_tuple["getBuffer(int)"](__args[0])) ;
    } else if (typeof __super_getBuffer != 'undefined') {
      return __super_getBuffer.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a boolean value at the end of the tuple.

   @public
   @param value {boolean} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addBoolean =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      j_tuple["addBoolean(java.lang.Boolean)"](__args[0]) ;
      return that;
    } else if (typeof __super_addBoolean != 'undefined') {
      return __super_addBoolean.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add an object value at the end of the tuple.

   @public
   @param value {Object} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addValue =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] !== 'function') {
      j_tuple["addValue(java.lang.Object)"](utils.convParamTypeUnknown(__args[0])) ;
      return that;
    } else if (typeof __super_addValue != 'undefined') {
      return __super_addValue.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a short value at the end of the tuple.

   @public
   @param value {number} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addShort =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      j_tuple["addShort(java.lang.Short)"](utils.convParamShort(__args[0])) ;
      return that;
    } else if (typeof __super_addShort != 'undefined') {
      return __super_addShort.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add an integer value at the end of the tuple.

   @public
   @param value {number} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addInteger =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      j_tuple["addInteger(java.lang.Integer)"](utils.convParamInteger(__args[0])) ;
      return that;
    } else if (typeof __super_addInteger != 'undefined') {
      return __super_addInteger.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a long value at the end of the tuple.

   @public
   @param value {number} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addLong =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      j_tuple["addLong(java.lang.Long)"](utils.convParamLong(__args[0])) ;
      return that;
    } else if (typeof __super_addLong != 'undefined') {
      return __super_addLong.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a float value at the end of the tuple.

   @public
   @param value {number} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addFloat =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      j_tuple["addFloat(java.lang.Float)"](utils.convParamFloat(__args[0])) ;
      return that;
    } else if (typeof __super_addFloat != 'undefined') {
      return __super_addFloat.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a double value at the end of the tuple.

   @public
   @param value {number} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addDouble =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      j_tuple["addDouble(java.lang.Double)"](utils.convParamDouble(__args[0])) ;
      return that;
    } else if (typeof __super_addDouble != 'undefined') {
      return __super_addDouble.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a string value at the end of the tuple.

   @public
   @param value {string} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addString =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_tuple["addString(java.lang.String)"](__args[0]) ;
      return that;
    } else if (typeof __super_addString != 'undefined') {
      return __super_addString.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a json value at the end of the tuple.

   @public
   @param value {Json} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addJson =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_tuple["addJson(io.reactiverse.pgclient.data.Json)"](__args[0]._jdel) ;
      return that;
    } else if (typeof __super_addJson != 'undefined') {
      return __super_addJson.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a buffer value at the end of the tuple.

   @public
   @param value {Buffer} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addBuffer =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_tuple["addBuffer(io.vertx.core.buffer.Buffer)"](__args[0]._jdel) ;
      return that;
    } else if (typeof __super_addBuffer != 'undefined') {
      return __super_addBuffer.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a  value at the end of the tuple.

   @public
   @param value {Object} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addPoint =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_tuple["addPoint(io.reactiverse.pgclient.data.Point)"](__args[0]  != null ? new Point(new JsonObject(Java.asJSONCompatible(__args[0]))) : null) ;
      return that;
    } else if (typeof __super_addPoint != 'undefined') {
      return __super_addPoint.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a  value at the end of the tuple.

   @public
   @param value {Object} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addLine =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_tuple["addLine(io.reactiverse.pgclient.data.Line)"](__args[0]  != null ? new Line(new JsonObject(Java.asJSONCompatible(__args[0]))) : null) ;
      return that;
    } else if (typeof __super_addLine != 'undefined') {
      return __super_addLine.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a  value at the end of the tuple.

   @public
   @param value {Object} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addLineSegment =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_tuple["addLineSegment(io.reactiverse.pgclient.data.LineSegment)"](__args[0]  != null ? new LineSegment(new JsonObject(Java.asJSONCompatible(__args[0]))) : null) ;
      return that;
    } else if (typeof __super_addLineSegment != 'undefined') {
      return __super_addLineSegment.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a  value at the end of the tuple.

   @public
   @param value {Object} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addBox =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_tuple["addBox(io.reactiverse.pgclient.data.Box)"](__args[0]  != null ? new Box(new JsonObject(Java.asJSONCompatible(__args[0]))) : null) ;
      return that;
    } else if (typeof __super_addBox != 'undefined') {
      return __super_addBox.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a  value at the end of the tuple.

   @public
   @param value {Object} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addPath =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_tuple["addPath(io.reactiverse.pgclient.data.Path)"](__args[0]  != null ? new Path(new JsonObject(Java.asJSONCompatible(__args[0]))) : null) ;
      return that;
    } else if (typeof __super_addPath != 'undefined') {
      return __super_addPath.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a  value at the end of the tuple.

   @public
   @param value {Object} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addPolygon =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_tuple["addPolygon(io.reactiverse.pgclient.data.Polygon)"](__args[0]  != null ? new Polygon(new JsonObject(Java.asJSONCompatible(__args[0]))) : null) ;
      return that;
    } else if (typeof __super_addPolygon != 'undefined') {
      return __super_addPolygon.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a  value at the end of the tuple.

   @public
   @param value {Object} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addCircle =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_tuple["addCircle(io.reactiverse.pgclient.data.Circle)"](__args[0]  != null ? new Circle(new JsonObject(Java.asJSONCompatible(__args[0]))) : null) ;
      return that;
    } else if (typeof __super_addCircle != 'undefined') {
      return __super_addCircle.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a  value at the end of the tuple.

   @public
   @param value {Object} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addInterval =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_tuple["addInterval(io.reactiverse.pgclient.data.Interval)"](__args[0]  != null ? new Interval(new JsonObject(Java.asJSONCompatible(__args[0]))) : null) ;
      return that;
    } else if (typeof __super_addInterval != 'undefined') {
      return __super_addInterval.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} the tuple size
   */
  this.size =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_tuple["size()"]() ;
    } else if (typeof __super_size != 'undefined') {
      return __super_size.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   */
  this.clear =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_tuple["clear()"]();
    } else if (typeof __super_clear != 'undefined') {
      return __super_clear.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_tuple;
};

Tuple._jclass = utils.getJavaClass("io.reactiverse.pgclient.Tuple");
Tuple._jtype = {accept: function(obj) {
    return Tuple._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(Tuple.prototype, {});
    Tuple.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
Tuple._create = function(jdel) {var obj = Object.create(Tuple.prototype, {});
  Tuple.apply(obj, arguments);
  return obj;
}
/**

 @memberof module:reactive-pg-client-js/tuple

 @return {Tuple} a new empty tuple
 */
Tuple.tuple =  function() {
  var __args = arguments;
  if (__args.length === 0) {
    return utils.convReturnVertxGen(Tuple, JTuple["tuple()"]()) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

/**
 Create a tuple of six elements.

 @memberof module:reactive-pg-client-js/tuple
 @param elt1 {Object} the first value 
 @param elt2 {Object} the second valueg 
 @param elt3 {Object} the third value 
 @param elt4 {Object} the fourth value 
 @param elt5 {Object} the fifth value 
 @param elt6 {Object} the sixth value 
 @return {Tuple} the tuple
 */
Tuple.of =  function() {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] !== 'function') {
    return utils.convReturnVertxGen(Tuple, JTuple["of(java.lang.Object)"](utils.convParamTypeUnknown(__args[0]))) ;
  } else if (__args.length === 2 && typeof __args[0] !== 'function' && typeof __args[1] !== 'function') {
    return utils.convReturnVertxGen(Tuple, JTuple["of(java.lang.Object,java.lang.Object)"](utils.convParamTypeUnknown(__args[0]), utils.convParamTypeUnknown(__args[1]))) ;
  } else if (__args.length === 3 && typeof __args[0] !== 'function' && typeof __args[1] !== 'function' && typeof __args[2] !== 'function') {
    return utils.convReturnVertxGen(Tuple, JTuple["of(java.lang.Object,java.lang.Object,java.lang.Object)"](utils.convParamTypeUnknown(__args[0]), utils.convParamTypeUnknown(__args[1]), utils.convParamTypeUnknown(__args[2]))) ;
  } else if (__args.length === 4 && typeof __args[0] !== 'function' && typeof __args[1] !== 'function' && typeof __args[2] !== 'function' && typeof __args[3] !== 'function') {
    return utils.convReturnVertxGen(Tuple, JTuple["of(java.lang.Object,java.lang.Object,java.lang.Object,java.lang.Object)"](utils.convParamTypeUnknown(__args[0]), utils.convParamTypeUnknown(__args[1]), utils.convParamTypeUnknown(__args[2]), utils.convParamTypeUnknown(__args[3]))) ;
  } else if (__args.length === 5 && typeof __args[0] !== 'function' && typeof __args[1] !== 'function' && typeof __args[2] !== 'function' && typeof __args[3] !== 'function' && typeof __args[4] !== 'function') {
    return utils.convReturnVertxGen(Tuple, JTuple["of(java.lang.Object,java.lang.Object,java.lang.Object,java.lang.Object,java.lang.Object)"](utils.convParamTypeUnknown(__args[0]), utils.convParamTypeUnknown(__args[1]), utils.convParamTypeUnknown(__args[2]), utils.convParamTypeUnknown(__args[3]), utils.convParamTypeUnknown(__args[4]))) ;
  } else if (__args.length === 6 && typeof __args[0] !== 'function' && typeof __args[1] !== 'function' && typeof __args[2] !== 'function' && typeof __args[3] !== 'function' && typeof __args[4] !== 'function' && typeof __args[5] !== 'function') {
    return utils.convReturnVertxGen(Tuple, JTuple["of(java.lang.Object,java.lang.Object,java.lang.Object,java.lang.Object,java.lang.Object,java.lang.Object)"](utils.convParamTypeUnknown(__args[0]), utils.convParamTypeUnknown(__args[1]), utils.convParamTypeUnknown(__args[2]), utils.convParamTypeUnknown(__args[3]), utils.convParamTypeUnknown(__args[4]), utils.convParamTypeUnknown(__args[5]))) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = Tuple;