require 'reactive-pg-client/pg_row_set'
require 'vertx/util/utils.rb'
# Generated from io.reactiverse.pgclient.PgCursor
module ReactivePgClient
  #  A cursor that reads progressively the rows from Postgres, it is usefull for reading very large result.
  class PgCursor
    # @private
    # @param j_del [::ReactivePgClient::PgCursor] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::ReactivePgClient::PgCursor] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == PgCursor
    end
    def @@j_api_type.wrap(obj)
      PgCursor.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoReactiversePgclient::PgCursor.java_class
    end
    #  Read rows from the cursor, the result is provided asynchronously to the <code>handler</code>.
    # @param [Fixnum] count the amount of rows to read
    # @yield the handler for the result
    # @return [void]
    def read(count=nil)
      if count.class == Fixnum && block_given?
        return @j_del.java_method(:read, [Java::int.java_class,Java::IoVertxCore::Handler.java_class]).call(count,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::ReactivePgClient::PgRowSet) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling read(#{count})"
    end
    #  Returns <code>true</code> when the cursor has results in progress and the  should be called to retrieve
    #  them.
    # @return [true,false] whether the cursor has more results,
    def has_more?
      if !block_given?
        return @j_del.java_method(:hasMore, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling has_more?()"
    end
    #  Like {::ReactivePgClient::PgCursor#close} but with a <code>completionHandler</code> called when the cursor has been released.
    # @yield 
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      elsif block_given?
        return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
  end
end
