require 'reactive-pg-client/row'
require 'vertx/util/utils.rb'
# Generated from io.reactiverse.pgclient.PgIterator
module ReactivePgClient
  #  An iterator for processing postgres items synchronously.
  class PgIterator
    # @private
    # @param j_del [::ReactivePgClient::PgIterator] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::ReactivePgClient::PgIterator] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == PgIterator
    end
    def @@j_api_type.wrap(obj)
      PgIterator.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoReactiversePgclient::PgIterator.java_class
    end
    # @return [true,false]
    def has_next?
      if !block_given?
        return @j_del.java_method(:hasNext, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling has_next?()"
    end
    # @return [::ReactivePgClient::Row]
    def next
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:next, []).call(),::ReactivePgClient::Row)
      end
      raise ArgumentError, "Invalid arguments when calling next()"
    end
  end
end
