require 'reactive-pg-client/pg_client'
require 'reactive-pg-client/pg_transaction'
require 'reactive-pg-client/tuple'
require 'reactive-pg-client/pg_connection'
require 'reactive-pg-client/pg_row_set'
require 'vertx/util/utils.rb'
# Generated from io.reactiverse.pgclient.PgPool
module ReactivePgClient
  #  A pool of connection.
  class PgPool < ::ReactivePgClient::PgClient
    # @private
    # @param j_del [::ReactivePgClient::PgPool] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::ReactivePgClient::PgPool] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == PgPool
    end
    def @@j_api_type.wrap(obj)
      PgPool.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoReactiversePgclient::PgPool.java_class
    end
    # @param [String] sql 
    # @param [::ReactivePgClient::Tuple] arguments 
    # @yield 
    # @return [self]
    def prepared_query(sql=nil,arguments=nil)
      if sql.class == String && block_given? && arguments == nil
        @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::ReactivePgClient::PgRowSet) : nil) }))
        return self
      elsif sql.class == String && arguments.class.method_defined?(:j_del) && block_given?
        @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoReactiversePgclient::Tuple.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,arguments.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::ReactivePgClient::PgRowSet) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling prepared_query(#{sql},#{arguments})"
    end
    # @param [String] sql 
    # @yield 
    # @return [self]
    def query(sql=nil)
      if sql.class == String && block_given?
        @j_del.java_method(:query, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::ReactivePgClient::PgRowSet) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling query(#{sql})"
    end
    # @param [String] sql 
    # @param [Array<::ReactivePgClient::Tuple>] batch 
    # @yield 
    # @return [self]
    def prepared_batch(sql=nil,batch=nil)
      if sql.class == String && batch.class == Array && block_given?
        @j_del.java_method(:preparedBatch, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,batch.map { |element| element.j_del },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::ReactivePgClient::PgRowSet) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling prepared_batch(#{sql},#{batch})"
    end
    #  Get a connection from the pool.
    # @yield the handler that will get the connection result
    # @return [void]
    def get_connection
      if block_given?
        return @j_del.java_method(:getConnection, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::ReactivePgClient::PgConnection) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling get_connection()"
    end
    #  Borrow a connection from the pool and begin a transaction, the underlying connection will be returned
    #  to the pool when the transaction ends.
    # @yield 
    # @return [void]
    def begin
      if block_given?
        return @j_del.java_method(:begin, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::ReactivePgClient::PgTransaction) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling begin()"
    end
    #  Close the pool and release the associated resources.
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
  end
end
