require 'reactive-pg-client/row'
require 'reactive-pg-client/tuple'
require 'reactive-pg-client/pg_cursor'
require 'reactive-pg-client/pg_row_set'
require 'reactive-pg-client/pg_stream'
require 'vertx/util/utils.rb'
# Generated from io.reactiverse.pgclient.PgPreparedQuery
module ReactivePgClient
  #  A prepared query.
  class PgPreparedQuery
    # @private
    # @param j_del [::ReactivePgClient::PgPreparedQuery] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::ReactivePgClient::PgPreparedQuery] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == PgPreparedQuery
    end
    def @@j_api_type.wrap(obj)
      PgPreparedQuery.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoReactiversePgclient::PgPreparedQuery.java_class
    end
    #  Create a cursor with the provided <code>arguments</code>.
    # @param [::ReactivePgClient::Tuple] args the list of arguments
    # @yield 
    # @return [self]
    def execute(args=nil)
      if block_given? && args == nil
        @j_del.java_method(:execute, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::ReactivePgClient::PgRowSet) : nil) }))
        return self
      elsif args.class.method_defined?(:j_del) && block_given?
        @j_del.java_method(:execute, [Java::IoReactiversePgclient::Tuple.java_class,Java::IoVertxCore::Handler.java_class]).call(args.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::ReactivePgClient::PgRowSet) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling execute(#{args})"
    end
    #  Create a cursor with the provided <code>arguments</code>.
    # @param [::ReactivePgClient::Tuple] args the list of arguments
    # @return [::ReactivePgClient::PgCursor] the query
    def cursor(args=nil)
      if !block_given? && args == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:cursor, []).call(),::ReactivePgClient::PgCursor)
      elsif args.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:cursor, [Java::IoReactiversePgclient::Tuple.java_class]).call(args.j_del),::ReactivePgClient::PgCursor)
      end
      raise ArgumentError, "Invalid arguments when calling cursor(#{args})"
    end
    #  Execute the prepared query with a cursor and createStream the result. The createStream opens a cursor
    #  with a <code>fetch</code> size to fetch the results.
    #  <p/>
    #  Note: this requires to be in a transaction, since cursors require it.
    # @param [Fixnum] fetch the cursor fetch size
    # @param [::ReactivePgClient::Tuple] args the prepared query arguments
    # @return [::ReactivePgClient::PgStream] the createStream
    def create_stream(fetch=nil,args=nil)
      if fetch.class == Fixnum && args.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createStream, [Java::int.java_class,Java::IoReactiversePgclient::Tuple.java_class]).call(fetch,args.j_del),::ReactivePgClient::PgStream,::ReactivePgClient::Row.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling create_stream(#{fetch},#{args})"
    end
    #  Execute a batch.
    # @param [Array<::ReactivePgClient::Tuple>] argsList the list of tuple for the batch
    # @yield 
    # @return [self]
    def batch(argsList=nil)
      if argsList.class == Array && block_given?
        @j_del.java_method(:batch, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(argsList.map { |element| element.j_del },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::ReactivePgClient::PgRowSet) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling batch(#{argsList})"
    end
    #  Like {::ReactivePgClient::PgPreparedQuery#close} but notifies the <code>completionHandler</code> when it's closed.
    # @yield 
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      elsif block_given?
        return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
  end
end
