require 'reactive-pg-client/json'
require 'vertx/buffer'
require 'reactive-pg-client/tuple'
require 'vertx/util/utils.rb'
# Generated from io.reactiverse.pgclient.Row
module ReactivePgClient
  class Row < ::ReactivePgClient::Tuple
    # @private
    # @param j_del [::ReactivePgClient::Row] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::ReactivePgClient::Row] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Row
    end
    def @@j_api_type.wrap(obj)
      Row.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoReactiversePgclient::Row.java_class
    end
    #  Get a boolean value at <code>pos</code>.
    # @overload getBoolean(pos)
    #   @param [Fixnum] pos the position
    # @overload getBoolean(name)
    #   @param [String] name the column
    # @return [true,false] the value or <code>null</code>
    def get_boolean?(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return @j_del.java_method(:getBoolean, [Java::int.java_class]).call(param_1)
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:getBoolean, [Java::java.lang.String.java_class]).call(param_1)
      end
      raise ArgumentError, "Invalid arguments when calling get_boolean?(#{param_1})"
    end
    #  Get an object value at <code>pos</code>.
    # @overload getValue(pos)
    #   @param [Fixnum] pos the position
    # @overload getValue(name)
    #   @param [String] name the column
    # @return [Object] the value or <code>null</code>
    def get_value(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:getValue, [Java::int.java_class]).call(param_1))
      elsif param_1.class == String && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:getValue, [Java::java.lang.String.java_class]).call(param_1))
      end
      raise ArgumentError, "Invalid arguments when calling get_value(#{param_1})"
    end
    #  Get a short value at <code>pos</code>.
    # @overload getShort(pos)
    #   @param [Fixnum] pos the position
    # @overload getShort(name)
    #   @param [String] name the column
    # @return [Fixnum] the value or <code>null</code>
    def get_short(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return @j_del.java_method(:getShort, [Java::int.java_class]).call(param_1)
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:getShort, [Java::java.lang.String.java_class]).call(param_1)
      end
      raise ArgumentError, "Invalid arguments when calling get_short(#{param_1})"
    end
    #  Get an integer value at <code>pos</code>.
    # @overload getInteger(pos)
    #   @param [Fixnum] pos the position
    # @overload getInteger(name)
    #   @param [String] name the column
    # @return [Fixnum] the value or <code>null</code>
    def get_integer(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return @j_del.java_method(:getInteger, [Java::int.java_class]).call(param_1)
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:getInteger, [Java::java.lang.String.java_class]).call(param_1)
      end
      raise ArgumentError, "Invalid arguments when calling get_integer(#{param_1})"
    end
    #  Get a long value at <code>pos</code>.
    # @overload getLong(pos)
    #   @param [Fixnum] pos the position
    # @overload getLong(name)
    #   @param [String] name the column
    # @return [Fixnum] the value or <code>null</code>
    def get_long(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return @j_del.java_method(:getLong, [Java::int.java_class]).call(param_1)
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:getLong, [Java::java.lang.String.java_class]).call(param_1)
      end
      raise ArgumentError, "Invalid arguments when calling get_long(#{param_1})"
    end
    #  Get a float value at <code>pos</code>.
    # @overload getFloat(pos)
    #   @param [Fixnum] pos the position
    # @overload getFloat(name)
    #   @param [String] name the column
    # @return [Float] the value or <code>null</code>
    def get_float(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return @j_del.java_method(:getFloat, [Java::int.java_class]).call(param_1)
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:getFloat, [Java::java.lang.String.java_class]).call(param_1)
      end
      raise ArgumentError, "Invalid arguments when calling get_float(#{param_1})"
    end
    #  Get a double value at <code>pos</code>.
    # @overload getDouble(pos)
    #   @param [Fixnum] pos the position
    # @overload getDouble(name)
    #   @param [String] name the column
    # @return [Float] the value or <code>null</code>
    def get_double(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return @j_del.java_method(:getDouble, [Java::int.java_class]).call(param_1)
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:getDouble, [Java::java.lang.String.java_class]).call(param_1)
      end
      raise ArgumentError, "Invalid arguments when calling get_double(#{param_1})"
    end
    #  Get a string value at <code>pos</code>.
    # @overload getString(pos)
    #   @param [Fixnum] pos the position
    # @overload getString(name)
    #   @param [String] name the column
    # @return [String] the value or <code>null</code>
    def get_string(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return @j_del.java_method(:getString, [Java::int.java_class]).call(param_1)
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:getString, [Java::java.lang.String.java_class]).call(param_1)
      end
      raise ArgumentError, "Invalid arguments when calling get_string(#{param_1})"
    end
    #  Get a json value at <code>pos</code>.
    # @overload getJson(pos)
    #   @param [Fixnum] pos the position
    # @overload getJson(name)
    #   @param [String] name the column
    # @return [::ReactivePgClient::Json] the value or <code>null</code>
    def get_json(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getJson, [Java::int.java_class]).call(param_1),::ReactivePgClient::Json)
      elsif param_1.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getJson, [Java::java.lang.String.java_class]).call(param_1),::ReactivePgClient::Json)
      end
      raise ArgumentError, "Invalid arguments when calling get_json(#{param_1})"
    end
    #  Get  value at <code>pos</code>.
    # @overload getPoint(pos)
    #   @param [Fixnum] pos the position
    # @overload getPoint(name)
    #   @param [String] name the column
    # @return [Hash] the value or <code>null</code>
    def get_point(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return @j_del.java_method(:getPoint, [Java::int.java_class]).call(param_1) != nil ? JSON.parse(@j_del.java_method(:getPoint, [Java::int.java_class]).call(param_1).toJson.encode) : nil
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:getPoint, [Java::java.lang.String.java_class]).call(param_1) != nil ? JSON.parse(@j_del.java_method(:getPoint, [Java::java.lang.String.java_class]).call(param_1).toJson.encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling get_point(#{param_1})"
    end
    #  Get  value at <code>pos</code>.
    # @overload getLine(pos)
    #   @param [Fixnum] pos the position
    # @overload getLine(name)
    #   @param [String] name the column
    # @return [Hash] the value or <code>null</code>
    def get_line(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return @j_del.java_method(:getLine, [Java::int.java_class]).call(param_1) != nil ? JSON.parse(@j_del.java_method(:getLine, [Java::int.java_class]).call(param_1).toJson.encode) : nil
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:getLine, [Java::java.lang.String.java_class]).call(param_1) != nil ? JSON.parse(@j_del.java_method(:getLine, [Java::java.lang.String.java_class]).call(param_1).toJson.encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling get_line(#{param_1})"
    end
    #  Get  value at <code>pos</code>.
    # @overload getLineSegment(pos)
    #   @param [Fixnum] pos the position
    # @overload getLineSegment(name)
    #   @param [String] name the column
    # @return [Hash] the value or <code>null</code>
    def get_line_segment(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return @j_del.java_method(:getLineSegment, [Java::int.java_class]).call(param_1) != nil ? JSON.parse(@j_del.java_method(:getLineSegment, [Java::int.java_class]).call(param_1).toJson.encode) : nil
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:getLineSegment, [Java::java.lang.String.java_class]).call(param_1) != nil ? JSON.parse(@j_del.java_method(:getLineSegment, [Java::java.lang.String.java_class]).call(param_1).toJson.encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling get_line_segment(#{param_1})"
    end
    #  Get  value at <code>pos</code>.
    # @overload getBox(pos)
    #   @param [Fixnum] pos the position
    # @overload getBox(name)
    #   @param [String] name the column
    # @return [Hash] the value or <code>null</code>
    def get_box(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return @j_del.java_method(:getBox, [Java::int.java_class]).call(param_1) != nil ? JSON.parse(@j_del.java_method(:getBox, [Java::int.java_class]).call(param_1).toJson.encode) : nil
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:getBox, [Java::java.lang.String.java_class]).call(param_1) != nil ? JSON.parse(@j_del.java_method(:getBox, [Java::java.lang.String.java_class]).call(param_1).toJson.encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling get_box(#{param_1})"
    end
    #  Get  value at <code>pos</code>.
    # @overload getPath(pos)
    #   @param [Fixnum] pos the position
    # @overload getPath(name)
    #   @param [String] name the column
    # @return [Hash] the value or <code>null</code>
    def get_path(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return @j_del.java_method(:getPath, [Java::int.java_class]).call(param_1) != nil ? JSON.parse(@j_del.java_method(:getPath, [Java::int.java_class]).call(param_1).toJson.encode) : nil
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:getPath, [Java::java.lang.String.java_class]).call(param_1) != nil ? JSON.parse(@j_del.java_method(:getPath, [Java::java.lang.String.java_class]).call(param_1).toJson.encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling get_path(#{param_1})"
    end
    #  Get  value at <code>pos</code>.
    # @overload getPolygon(pos)
    #   @param [Fixnum] pos the position
    # @overload getPolygon(name)
    #   @param [String] name the column
    # @return [Hash] the value or <code>null</code>
    def get_polygon(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return @j_del.java_method(:getPolygon, [Java::int.java_class]).call(param_1) != nil ? JSON.parse(@j_del.java_method(:getPolygon, [Java::int.java_class]).call(param_1).toJson.encode) : nil
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:getPolygon, [Java::java.lang.String.java_class]).call(param_1) != nil ? JSON.parse(@j_del.java_method(:getPolygon, [Java::java.lang.String.java_class]).call(param_1).toJson.encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling get_polygon(#{param_1})"
    end
    #  Get  value at <code>pos</code>.
    # @overload getCircle(pos)
    #   @param [Fixnum] pos the position
    # @overload getCircle(name)
    #   @param [String] name the column
    # @return [Hash] the value or <code>null</code>
    def get_circle(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return @j_del.java_method(:getCircle, [Java::int.java_class]).call(param_1) != nil ? JSON.parse(@j_del.java_method(:getCircle, [Java::int.java_class]).call(param_1).toJson.encode) : nil
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:getCircle, [Java::java.lang.String.java_class]).call(param_1) != nil ? JSON.parse(@j_del.java_method(:getCircle, [Java::java.lang.String.java_class]).call(param_1).toJson.encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling get_circle(#{param_1})"
    end
    #  Get  value at <code>pos</code>.
    # @overload getInterval(pos)
    #   @param [Fixnum] pos the position
    # @overload getInterval(name)
    #   @param [String] name the column
    # @return [Hash] the value or <code>null</code>
    def get_interval(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return @j_del.java_method(:getInterval, [Java::int.java_class]).call(param_1) != nil ? JSON.parse(@j_del.java_method(:getInterval, [Java::int.java_class]).call(param_1).toJson.encode) : nil
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:getInterval, [Java::java.lang.String.java_class]).call(param_1) != nil ? JSON.parse(@j_del.java_method(:getInterval, [Java::java.lang.String.java_class]).call(param_1).toJson.encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling get_interval(#{param_1})"
    end
    #  Get a buffer value at <code>pos</code>.
    # @overload getBuffer(pos)
    #   @param [Fixnum] pos the position
    # @overload getBuffer(name)
    #   @param [String] name the column
    # @return [::Vertx::Buffer] the value or <code>null</code>
    def get_buffer(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getBuffer, [Java::int.java_class]).call(param_1),::Vertx::Buffer)
      elsif param_1.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getBuffer, [Java::java.lang.String.java_class]).call(param_1),::Vertx::Buffer)
      end
      raise ArgumentError, "Invalid arguments when calling get_buffer(#{param_1})"
    end
    #  Add a boolean value at the end of the tuple.
    # @param [true,false] value the value
    # @return [self]
    def add_boolean(value=nil)
      if (value.class == TrueClass || value.class == FalseClass) && !block_given?
        @j_del.java_method(:addBoolean, [Java::JavaLang::Boolean.java_class]).call(value)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_boolean(#{value})"
    end
    #  Add an object value at the end of the tuple.
    # @param [Object] value the value
    # @return [self]
    def add_value(value=nil)
      if ::Vertx::Util::unknown_type.accept?(value) && !block_given?
        @j_del.java_method(:addValue, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(value))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_value(#{value})"
    end
    #  Add a short value at the end of the tuple.
    # @param [Fixnum] value the value
    # @return [self]
    def add_short(value=nil)
      if value.class == Fixnum && !block_given?
        @j_del.java_method(:addShort, [Java::JavaLang::Short.java_class]).call(::Vertx::Util::Utils.to_short(value))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_short(#{value})"
    end
    #  Add an integer value at the end of the tuple.
    # @param [Fixnum] value the value
    # @return [self]
    def add_integer(value=nil)
      if value.class == Fixnum && !block_given?
        @j_del.java_method(:addInteger, [Java::JavaLang::Integer.java_class]).call(::Vertx::Util::Utils.to_integer(value))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_integer(#{value})"
    end
    #  Add a long value at the end of the tuple.
    # @param [Fixnum] value the value
    # @return [self]
    def add_long(value=nil)
      if value.class == Fixnum && !block_given?
        @j_del.java_method(:addLong, [Java::JavaLang::Long.java_class]).call(value)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_long(#{value})"
    end
    #  Add a float value at the end of the tuple.
    # @param [Float] value the value
    # @return [self]
    def add_float(value=nil)
      if value.class == Float && !block_given?
        @j_del.java_method(:addFloat, [Java::JavaLang::Float.java_class]).call(::Vertx::Util::Utils.to_float(value))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_float(#{value})"
    end
    #  Add a double value at the end of the tuple.
    # @param [Float] value the value
    # @return [self]
    def add_double(value=nil)
      if value.class == Float && !block_given?
        @j_del.java_method(:addDouble, [Java::JavaLang::Double.java_class]).call(::Vertx::Util::Utils.to_double(value))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_double(#{value})"
    end
    #  Add a string value at the end of the tuple.
    # @param [String] value the value
    # @return [self]
    def add_string(value=nil)
      if value.class == String && !block_given?
        @j_del.java_method(:addString, [Java::java.lang.String.java_class]).call(value)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_string(#{value})"
    end
    #  Add a json value at the end of the tuple.
    # @param [::ReactivePgClient::Json] value the value
    # @return [self]
    def add_json(value=nil)
      if value.class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:addJson, [Java::IoReactiversePgclientData::Json.java_class]).call(value.j_del)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_json(#{value})"
    end
    #  Add a buffer value at the end of the tuple.
    # @param [::Vertx::Buffer] value the value
    # @return [self]
    def add_buffer(value=nil)
      if value.class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:addBuffer, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(value.j_del)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_buffer(#{value})"
    end
    #  Add a  value at the end of the tuple.
    # @param [Hash] value the value
    # @return [self]
    def add_point(value=nil)
      if value.class == Hash && !block_given?
        @j_del.java_method(:addPoint, [Java::IoReactiversePgclientData::Point.java_class]).call(Java::IoReactiversePgclientData::Point.new(::Vertx::Util::Utils.to_json_object(value)))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_point(#{value})"
    end
    #  Add a  value at the end of the tuple.
    # @param [Hash] value the value
    # @return [self]
    def add_line(value=nil)
      if value.class == Hash && !block_given?
        @j_del.java_method(:addLine, [Java::IoReactiversePgclientData::Line.java_class]).call(Java::IoReactiversePgclientData::Line.new(::Vertx::Util::Utils.to_json_object(value)))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_line(#{value})"
    end
    #  Add a  value at the end of the tuple.
    # @param [Hash] value the value
    # @return [self]
    def add_line_segment(value=nil)
      if value.class == Hash && !block_given?
        @j_del.java_method(:addLineSegment, [Java::IoReactiversePgclientData::LineSegment.java_class]).call(Java::IoReactiversePgclientData::LineSegment.new(::Vertx::Util::Utils.to_json_object(value)))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_line_segment(#{value})"
    end
    #  Add a  value at the end of the tuple.
    # @param [Hash] value the value
    # @return [self]
    def add_box(value=nil)
      if value.class == Hash && !block_given?
        @j_del.java_method(:addBox, [Java::IoReactiversePgclientData::Box.java_class]).call(Java::IoReactiversePgclientData::Box.new(::Vertx::Util::Utils.to_json_object(value)))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_box(#{value})"
    end
    #  Add a  value at the end of the tuple.
    # @param [Hash] value the value
    # @return [self]
    def add_path(value=nil)
      if value.class == Hash && !block_given?
        @j_del.java_method(:addPath, [Java::IoReactiversePgclientData::Path.java_class]).call(Java::IoReactiversePgclientData::Path.new(::Vertx::Util::Utils.to_json_object(value)))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_path(#{value})"
    end
    #  Add a  value at the end of the tuple.
    # @param [Hash] value the value
    # @return [self]
    def add_polygon(value=nil)
      if value.class == Hash && !block_given?
        @j_del.java_method(:addPolygon, [Java::IoReactiversePgclientData::Polygon.java_class]).call(Java::IoReactiversePgclientData::Polygon.new(::Vertx::Util::Utils.to_json_object(value)))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_polygon(#{value})"
    end
    #  Add a  value at the end of the tuple.
    # @param [Hash] value the value
    # @return [self]
    def add_circle(value=nil)
      if value.class == Hash && !block_given?
        @j_del.java_method(:addCircle, [Java::IoReactiversePgclientData::Circle.java_class]).call(Java::IoReactiversePgclientData::Circle.new(::Vertx::Util::Utils.to_json_object(value)))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_circle(#{value})"
    end
    #  Add a  value at the end of the tuple.
    # @param [Hash] value the value
    # @return [self]
    def add_interval(value=nil)
      if value.class == Hash && !block_given?
        @j_del.java_method(:addInterval, [Java::IoReactiversePgclientData::Interval.java_class]).call(Java::IoReactiversePgclientData::Interval.new(::Vertx::Util::Utils.to_json_object(value)))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_interval(#{value})"
    end
    # @return [Fixnum] the tuple size
    def size
      if !block_given?
        return @j_del.java_method(:size, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling size()"
    end
    # @return [void]
    def clear
      if !block_given?
        return @j_del.java_method(:clear, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling clear()"
    end
    #  Get a column name at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [String] the column name or <code>null</code>
    def get_column_name(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getColumnName, [Java::int.java_class]).call(pos)
      end
      raise ArgumentError, "Invalid arguments when calling get_column_name(#{pos})"
    end
  end
end
