require 'reactive-pg-client/json'
require 'vertx/buffer'
require 'vertx/util/utils.rb'
# Generated from io.reactiverse.pgclient.Tuple
module ReactivePgClient
  #  A general purpose tuple.
  class Tuple
    # @private
    # @param j_del [::ReactivePgClient::Tuple] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::ReactivePgClient::Tuple] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Tuple
    end
    def @@j_api_type.wrap(obj)
      Tuple.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoReactiversePgclient::Tuple.java_class
    end
    # @return [::ReactivePgClient::Tuple] a new empty tuple
    def self.tuple
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoReactiversePgclient::Tuple.java_method(:tuple, []).call(),::ReactivePgClient::Tuple)
      end
      raise ArgumentError, "Invalid arguments when calling tuple()"
    end
    #  Create a tuple of six elements.
    # @param [Object] elt1 the first value
    # @param [Object] elt2 the second valueg
    # @param [Object] elt3 the third value
    # @param [Object] elt4 the fourth value
    # @param [Object] elt5 the fifth value
    # @param [Object] elt6 the sixth value
    # @return [::ReactivePgClient::Tuple] the tuple
    def self.of(elt1=nil,elt2=nil,elt3=nil,elt4=nil,elt5=nil,elt6=nil)
      if ::Vertx::Util::unknown_type.accept?(elt1) && !block_given? && elt2 == nil && elt3 == nil && elt4 == nil && elt5 == nil && elt6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoReactiversePgclient::Tuple.java_method(:of, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(elt1)),::ReactivePgClient::Tuple)
      elsif ::Vertx::Util::unknown_type.accept?(elt1) && ::Vertx::Util::unknown_type.accept?(elt2) && !block_given? && elt3 == nil && elt4 == nil && elt5 == nil && elt6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoReactiversePgclient::Tuple.java_method(:of, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(elt1),::Vertx::Util::Utils.to_object(elt2)),::ReactivePgClient::Tuple)
      elsif ::Vertx::Util::unknown_type.accept?(elt1) && ::Vertx::Util::unknown_type.accept?(elt2) && ::Vertx::Util::unknown_type.accept?(elt3) && !block_given? && elt4 == nil && elt5 == nil && elt6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoReactiversePgclient::Tuple.java_method(:of, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(elt1),::Vertx::Util::Utils.to_object(elt2),::Vertx::Util::Utils.to_object(elt3)),::ReactivePgClient::Tuple)
      elsif ::Vertx::Util::unknown_type.accept?(elt1) && ::Vertx::Util::unknown_type.accept?(elt2) && ::Vertx::Util::unknown_type.accept?(elt3) && ::Vertx::Util::unknown_type.accept?(elt4) && !block_given? && elt5 == nil && elt6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoReactiversePgclient::Tuple.java_method(:of, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(elt1),::Vertx::Util::Utils.to_object(elt2),::Vertx::Util::Utils.to_object(elt3),::Vertx::Util::Utils.to_object(elt4)),::ReactivePgClient::Tuple)
      elsif ::Vertx::Util::unknown_type.accept?(elt1) && ::Vertx::Util::unknown_type.accept?(elt2) && ::Vertx::Util::unknown_type.accept?(elt3) && ::Vertx::Util::unknown_type.accept?(elt4) && ::Vertx::Util::unknown_type.accept?(elt5) && !block_given? && elt6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoReactiversePgclient::Tuple.java_method(:of, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(elt1),::Vertx::Util::Utils.to_object(elt2),::Vertx::Util::Utils.to_object(elt3),::Vertx::Util::Utils.to_object(elt4),::Vertx::Util::Utils.to_object(elt5)),::ReactivePgClient::Tuple)
      elsif ::Vertx::Util::unknown_type.accept?(elt1) && ::Vertx::Util::unknown_type.accept?(elt2) && ::Vertx::Util::unknown_type.accept?(elt3) && ::Vertx::Util::unknown_type.accept?(elt4) && ::Vertx::Util::unknown_type.accept?(elt5) && ::Vertx::Util::unknown_type.accept?(elt6) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoReactiversePgclient::Tuple.java_method(:of, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(elt1),::Vertx::Util::Utils.to_object(elt2),::Vertx::Util::Utils.to_object(elt3),::Vertx::Util::Utils.to_object(elt4),::Vertx::Util::Utils.to_object(elt5),::Vertx::Util::Utils.to_object(elt6)),::ReactivePgClient::Tuple)
      end
      raise ArgumentError, "Invalid arguments when calling of(#{elt1},#{elt2},#{elt3},#{elt4},#{elt5},#{elt6})"
    end
    #  Get a boolean value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [true,false] the value or <code>null</code>
    def get_boolean?(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getBoolean, [Java::int.java_class]).call(pos)
      end
      raise ArgumentError, "Invalid arguments when calling get_boolean?(#{pos})"
    end
    #  Get an object value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [Object] the value or <code>null</code>
    def get_value(pos=nil)
      if pos.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:getValue, [Java::int.java_class]).call(pos))
      end
      raise ArgumentError, "Invalid arguments when calling get_value(#{pos})"
    end
    #  Get a short value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [Fixnum] the value or <code>null</code>
    def get_short(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getShort, [Java::int.java_class]).call(pos)
      end
      raise ArgumentError, "Invalid arguments when calling get_short(#{pos})"
    end
    #  Get an integer value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [Fixnum] the value or <code>null</code>
    def get_integer(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getInteger, [Java::int.java_class]).call(pos)
      end
      raise ArgumentError, "Invalid arguments when calling get_integer(#{pos})"
    end
    #  Get a long value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [Fixnum] the value or <code>null</code>
    def get_long(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getLong, [Java::int.java_class]).call(pos)
      end
      raise ArgumentError, "Invalid arguments when calling get_long(#{pos})"
    end
    #  Get a float value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [Float] the value or <code>null</code>
    def get_float(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getFloat, [Java::int.java_class]).call(pos)
      end
      raise ArgumentError, "Invalid arguments when calling get_float(#{pos})"
    end
    #  Get a double value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [Float] the value or <code>null</code>
    def get_double(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getDouble, [Java::int.java_class]).call(pos)
      end
      raise ArgumentError, "Invalid arguments when calling get_double(#{pos})"
    end
    #  Get a string value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [String] the value or <code>null</code>
    def get_string(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getString, [Java::int.java_class]).call(pos)
      end
      raise ArgumentError, "Invalid arguments when calling get_string(#{pos})"
    end
    #  Get a json value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [::ReactivePgClient::Json] the value or <code>null</code>
    def get_json(pos=nil)
      if pos.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getJson, [Java::int.java_class]).call(pos),::ReactivePgClient::Json)
      end
      raise ArgumentError, "Invalid arguments when calling get_json(#{pos})"
    end
    #  Get  value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [Hash] the value or <code>null</code>
    def get_point(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getPoint, [Java::int.java_class]).call(pos) != nil ? JSON.parse(@j_del.java_method(:getPoint, [Java::int.java_class]).call(pos).toJson.encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling get_point(#{pos})"
    end
    #  Get  value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [Hash] the value or <code>null</code>
    def get_line(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getLine, [Java::int.java_class]).call(pos) != nil ? JSON.parse(@j_del.java_method(:getLine, [Java::int.java_class]).call(pos).toJson.encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling get_line(#{pos})"
    end
    #  Get  value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [Hash] the value or <code>null</code>
    def get_line_segment(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getLineSegment, [Java::int.java_class]).call(pos) != nil ? JSON.parse(@j_del.java_method(:getLineSegment, [Java::int.java_class]).call(pos).toJson.encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling get_line_segment(#{pos})"
    end
    #  Get  value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [Hash] the value or <code>null</code>
    def get_box(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getBox, [Java::int.java_class]).call(pos) != nil ? JSON.parse(@j_del.java_method(:getBox, [Java::int.java_class]).call(pos).toJson.encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling get_box(#{pos})"
    end
    #  Get  value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [Hash] the value or <code>null</code>
    def get_path(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getPath, [Java::int.java_class]).call(pos) != nil ? JSON.parse(@j_del.java_method(:getPath, [Java::int.java_class]).call(pos).toJson.encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling get_path(#{pos})"
    end
    #  Get  value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [Hash] the value or <code>null</code>
    def get_polygon(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getPolygon, [Java::int.java_class]).call(pos) != nil ? JSON.parse(@j_del.java_method(:getPolygon, [Java::int.java_class]).call(pos).toJson.encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling get_polygon(#{pos})"
    end
    #  Get  value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [Hash] the value or <code>null</code>
    def get_circle(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getCircle, [Java::int.java_class]).call(pos) != nil ? JSON.parse(@j_del.java_method(:getCircle, [Java::int.java_class]).call(pos).toJson.encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling get_circle(#{pos})"
    end
    #  Get  value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [Hash] the value or <code>null</code>
    def get_interval(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getInterval, [Java::int.java_class]).call(pos) != nil ? JSON.parse(@j_del.java_method(:getInterval, [Java::int.java_class]).call(pos).toJson.encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling get_interval(#{pos})"
    end
    #  Get a buffer value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [::Vertx::Buffer] the value or <code>null</code>
    def get_buffer(pos=nil)
      if pos.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getBuffer, [Java::int.java_class]).call(pos),::Vertx::Buffer)
      end
      raise ArgumentError, "Invalid arguments when calling get_buffer(#{pos})"
    end
    #  Add a boolean value at the end of the tuple.
    # @param [true,false] value the value
    # @return [self]
    def add_boolean(value=nil)
      if (value.class == TrueClass || value.class == FalseClass) && !block_given?
        @j_del.java_method(:addBoolean, [Java::JavaLang::Boolean.java_class]).call(value)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_boolean(#{value})"
    end
    #  Add an object value at the end of the tuple.
    # @param [Object] value the value
    # @return [self]
    def add_value(value=nil)
      if ::Vertx::Util::unknown_type.accept?(value) && !block_given?
        @j_del.java_method(:addValue, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(value))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_value(#{value})"
    end
    #  Add a short value at the end of the tuple.
    # @param [Fixnum] value the value
    # @return [self]
    def add_short(value=nil)
      if value.class == Fixnum && !block_given?
        @j_del.java_method(:addShort, [Java::JavaLang::Short.java_class]).call(::Vertx::Util::Utils.to_short(value))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_short(#{value})"
    end
    #  Add an integer value at the end of the tuple.
    # @param [Fixnum] value the value
    # @return [self]
    def add_integer(value=nil)
      if value.class == Fixnum && !block_given?
        @j_del.java_method(:addInteger, [Java::JavaLang::Integer.java_class]).call(::Vertx::Util::Utils.to_integer(value))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_integer(#{value})"
    end
    #  Add a long value at the end of the tuple.
    # @param [Fixnum] value the value
    # @return [self]
    def add_long(value=nil)
      if value.class == Fixnum && !block_given?
        @j_del.java_method(:addLong, [Java::JavaLang::Long.java_class]).call(value)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_long(#{value})"
    end
    #  Add a float value at the end of the tuple.
    # @param [Float] value the value
    # @return [self]
    def add_float(value=nil)
      if value.class == Float && !block_given?
        @j_del.java_method(:addFloat, [Java::JavaLang::Float.java_class]).call(::Vertx::Util::Utils.to_float(value))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_float(#{value})"
    end
    #  Add a double value at the end of the tuple.
    # @param [Float] value the value
    # @return [self]
    def add_double(value=nil)
      if value.class == Float && !block_given?
        @j_del.java_method(:addDouble, [Java::JavaLang::Double.java_class]).call(::Vertx::Util::Utils.to_double(value))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_double(#{value})"
    end
    #  Add a string value at the end of the tuple.
    # @param [String] value the value
    # @return [self]
    def add_string(value=nil)
      if value.class == String && !block_given?
        @j_del.java_method(:addString, [Java::java.lang.String.java_class]).call(value)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_string(#{value})"
    end
    #  Add a json value at the end of the tuple.
    # @param [::ReactivePgClient::Json] value the value
    # @return [self]
    def add_json(value=nil)
      if value.class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:addJson, [Java::IoReactiversePgclientData::Json.java_class]).call(value.j_del)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_json(#{value})"
    end
    #  Add a buffer value at the end of the tuple.
    # @param [::Vertx::Buffer] value the value
    # @return [self]
    def add_buffer(value=nil)
      if value.class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:addBuffer, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(value.j_del)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_buffer(#{value})"
    end
    #  Add a  value at the end of the tuple.
    # @param [Hash] value the value
    # @return [self]
    def add_point(value=nil)
      if value.class == Hash && !block_given?
        @j_del.java_method(:addPoint, [Java::IoReactiversePgclientData::Point.java_class]).call(Java::IoReactiversePgclientData::Point.new(::Vertx::Util::Utils.to_json_object(value)))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_point(#{value})"
    end
    #  Add a  value at the end of the tuple.
    # @param [Hash] value the value
    # @return [self]
    def add_line(value=nil)
      if value.class == Hash && !block_given?
        @j_del.java_method(:addLine, [Java::IoReactiversePgclientData::Line.java_class]).call(Java::IoReactiversePgclientData::Line.new(::Vertx::Util::Utils.to_json_object(value)))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_line(#{value})"
    end
    #  Add a  value at the end of the tuple.
    # @param [Hash] value the value
    # @return [self]
    def add_line_segment(value=nil)
      if value.class == Hash && !block_given?
        @j_del.java_method(:addLineSegment, [Java::IoReactiversePgclientData::LineSegment.java_class]).call(Java::IoReactiversePgclientData::LineSegment.new(::Vertx::Util::Utils.to_json_object(value)))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_line_segment(#{value})"
    end
    #  Add a  value at the end of the tuple.
    # @param [Hash] value the value
    # @return [self]
    def add_box(value=nil)
      if value.class == Hash && !block_given?
        @j_del.java_method(:addBox, [Java::IoReactiversePgclientData::Box.java_class]).call(Java::IoReactiversePgclientData::Box.new(::Vertx::Util::Utils.to_json_object(value)))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_box(#{value})"
    end
    #  Add a  value at the end of the tuple.
    # @param [Hash] value the value
    # @return [self]
    def add_path(value=nil)
      if value.class == Hash && !block_given?
        @j_del.java_method(:addPath, [Java::IoReactiversePgclientData::Path.java_class]).call(Java::IoReactiversePgclientData::Path.new(::Vertx::Util::Utils.to_json_object(value)))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_path(#{value})"
    end
    #  Add a  value at the end of the tuple.
    # @param [Hash] value the value
    # @return [self]
    def add_polygon(value=nil)
      if value.class == Hash && !block_given?
        @j_del.java_method(:addPolygon, [Java::IoReactiversePgclientData::Polygon.java_class]).call(Java::IoReactiversePgclientData::Polygon.new(::Vertx::Util::Utils.to_json_object(value)))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_polygon(#{value})"
    end
    #  Add a  value at the end of the tuple.
    # @param [Hash] value the value
    # @return [self]
    def add_circle(value=nil)
      if value.class == Hash && !block_given?
        @j_del.java_method(:addCircle, [Java::IoReactiversePgclientData::Circle.java_class]).call(Java::IoReactiversePgclientData::Circle.new(::Vertx::Util::Utils.to_json_object(value)))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_circle(#{value})"
    end
    #  Add a  value at the end of the tuple.
    # @param [Hash] value the value
    # @return [self]
    def add_interval(value=nil)
      if value.class == Hash && !block_given?
        @j_del.java_method(:addInterval, [Java::IoReactiversePgclientData::Interval.java_class]).call(Java::IoReactiversePgclientData::Interval.new(::Vertx::Util::Utils.to_json_object(value)))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_interval(#{value})"
    end
    # @return [Fixnum] the tuple size
    def size
      if !block_given?
        return @j_del.java_method(:size, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling size()"
    end
    # @return [void]
    def clear
      if !block_given?
        return @j_del.java_method(:clear, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling clear()"
    end
  end
end
