/*
 * Decompiled with CFR 0.152.
 */
package examples;

import io.reactiverse.childprocess.Process;
import io.reactiverse.childprocess.ProcessBuilder;
import io.reactiverse.childprocess.ProcessOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.docgen.Source;
import java.util.Arrays;
import java.util.HashMap;

@Source
public class Examples {
    public void ex01(Vertx vertx) {
        ProcessBuilder processBuilder = Process.create(vertx, "ls");
        Future<Void> fut = processBuilder.start();
    }

    public void ex02(Vertx vertx) {
        Process.create(vertx, "ls", Arrays.asList("-lh", "/usr")).start();
    }

    public void ex03(Vertx vertx) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("MY_VAR", "whatever");
        Process.create(vertx, "ls", new ProcessOptions().setEnv(env)).start();
    }

    public void ex04(Vertx vertx) {
        ProcessOptions options = new ProcessOptions().setEnv(Process.env());
        Process.create(vertx, "ls", options).start();
    }

    public void ex05(Vertx vertx) {
        ProcessOptions options = new ProcessOptions().setCwd("/some-dir");
        Process.create(vertx, "ls", options).start();
    }

    public void ex10(Vertx vertx) {
        ProcessBuilder processBuilder = Process.create(vertx, "cat");
        processBuilder.startHandler((Handler<Process>)((Handler)process -> {
            process.stdout().handler((Handler<Buffer>)((Handler)buff -> System.out.println(buff.toString())));
            process.stdin().write(Buffer.buffer((String)"Hello World"));
        }));
        processBuilder.start();
    }

    public void ex20(Vertx vertx) {
        Process.create(vertx, "sleep", Arrays.asList("2")).startHandler((Handler<Process>)((Handler)process -> process.exitHandler((Handler<Integer>)((Handler)code -> System.out.println("Child process exited with code: " + code))))).start();
    }

    public void ex30(Vertx vertx) {
        Process.create(vertx, "cat").startHandler((Handler<Process>)((Handler)process -> {
            process.stdout().handler((Handler<Buffer>)((Handler)buff -> System.out.println(buff.toString())));
            process.stdin().write(Buffer.buffer((String)"Hello World"));
            process.kill();
        })).start();
    }

    public void ex31(Vertx vertx) {
        Process.create(vertx, "cat").startHandler((Handler<Process>)((Handler)process -> {
            process.stdout().handler((Handler<Buffer>)((Handler)buff -> System.out.println(buff.toString())));
            process.stdin().write(Buffer.buffer((String)"Hello World"));
            process.kill(true);
        })).start();
    }
}

