/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.childprocess.impl;

import com.zaxxer.nuprocess.NuProcess;
import io.reactiverse.childprocess.Process;
import io.reactiverse.childprocess.StreamInput;
import io.reactiverse.childprocess.StreamOutput;
import io.reactiverse.childprocess.impl.ProcessStreamInput;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;

public class ProcessImpl
implements Process,
StreamOutput {
    private static final int OPEN = 0;
    private static final int CLOSING = 1;
    private static final int CLOSED = 2;
    private int stdinStatus = 0;
    private Promise<Void> stdninEnd;
    private final ArrayDeque<Write> stdinPending = new ArrayDeque();
    private int stdinPendingSize;
    private int stdinMaxSize = 1024;
    private Handler<Void> drainHandler;
    private final ContextInternal context;
    private final ProcessStreamInput stdout;
    private final ProcessStreamInput stderr;
    private Handler<Integer> exitHandler;
    private final NuProcess process;
    private Promise<Integer> exitFuture;
    private boolean wantWrite;

    public ProcessImpl(ContextInternal context, NuProcess process) {
        this.context = context;
        this.process = process;
        this.stdout = new ProcessStreamInput(context);
        this.stderr = new ProcessStreamInput(context);
        this.exitFuture = context.promise();
        this.stdninEnd = context.promise();
    }

    @Override
    public synchronized Process exitHandler(Handler<Integer> handler) {
        this.exitHandler = handler;
        return this;
    }

    @Override
    public synchronized Integer pid() {
        return this.process.getPID();
    }

    @Override
    public StreamOutput stdin() {
        return this;
    }

    @Override
    public StreamInput stdout() {
        return this.stdout;
    }

    @Override
    public StreamInput stderr() {
        return this.stderr;
    }

    @Override
    public StreamOutput exceptionHandler(Handler<Throwable> handler) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> write(Buffer buffer) {
        PromiseInternal promise = this.context.promise();
        ProcessImpl processImpl = this;
        synchronized (processImpl) {
            if (this.stdinStatus == 1 || this.stdinStatus == 2) {
                throw new IllegalStateException();
            }
            this.stdinPending.add(new Write(buffer, (Promise<Void>)promise));
            this.stdinPendingSize += buffer.length();
            if (this.process != null && !this.wantWrite) {
                this.wantWrite = true;
                this.process.wantWrite();
            }
        }
        return promise.future();
    }

    @Override
    public synchronized StreamOutput setWriteQueueMaxSize(int i) {
        this.stdinMaxSize = i;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamOutput drainHandler(Handler<Void> handler) {
        ProcessImpl processImpl = this;
        synchronized (processImpl) {
            this.drainHandler = handler;
        }
        this.checkDrained();
        return this;
    }

    public synchronized boolean writeQueueFull() {
        return this.stdinPendingSize > this.stdinMaxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> close() {
        ProcessImpl processImpl = this;
        synchronized (processImpl) {
            if (this.stdinStatus != 0) {
                return this.stdninEnd.future();
            }
            if (this.stdinPendingSize != 0) {
                this.stdinStatus = 1;
                return this.stdninEnd.future();
            }
            this.stdinStatus = 2;
        }
        this.process.closeStdin(false);
        this.stdninEnd.complete();
        return this.stdninEnd.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onExit(int exitCode) {
        ProcessImpl processImpl = this;
        synchronized (processImpl) {
            this.stdinStatus = 2;
        }
        this.handleExit(exitCode);
    }

    private void handleExit(int exitCode) {
        this.exitFuture.complete((Object)exitCode);
        Handler<Integer> handler = this.exitHandler;
        if (handler != null) {
            this.context.emit((Object)exitCode, handler);
        }
    }

    public void onStdout(Buffer buffer, boolean closed) {
        if (buffer != null) {
            this.stdout.write(buffer);
        }
        if (closed) {
            this.stdout.close();
        }
    }

    public void onStderr(Buffer buffer, boolean closed) {
        if (buffer != null) {
            this.stderr.write(buffer);
        }
        if (closed) {
            this.stderr.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onStdinReady(ByteBuffer byteBuffer) {
        ProcessImpl processImpl = this;
        synchronized (processImpl) {
            Write write;
            while (byteBuffer.remaining() > 0 && (write = this.stdinPending.poll()) != null) {
                byte[] bytes;
                if (write.buffer.length() <= byteBuffer.remaining()) {
                    bytes = write.buffer.getBytes();
                    write.promise.complete();
                } else {
                    bytes = write.buffer.getBytes(0, byteBuffer.remaining());
                    this.stdinPending.addFirst(new Write(write.buffer.slice(byteBuffer.remaining(), write.buffer.length()), write.promise));
                }
                byteBuffer.put(bytes);
                this.stdinPendingSize -= bytes.length;
            }
            byteBuffer.flip();
            this.context.execute(v -> this.checkDrained());
            if (this.stdinPendingSize > 0) {
                return true;
            }
            this.wantWrite = false;
            if (this.stdinStatus != 1) {
                return false;
            }
            this.stdinStatus = 2;
        }
        this.process.closeStdin(false);
        this.stdninEnd.complete();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDrained() {
        Handler<Void> handler;
        ProcessImpl processImpl = this;
        synchronized (processImpl) {
            if (this.stdinPendingSize >= this.stdinMaxSize / 2) {
                return;
            }
            handler = this.drainHandler;
            this.drainHandler = null;
        }
        if (handler != null) {
            this.context.emit(handler);
        }
    }

    @Override
    public void kill(boolean force) {
        if (this.process != null) {
            this.process.destroy(force);
        }
    }

    @Override
    public boolean isRunning() {
        return this.process.isRunning();
    }

    private static class Write {
        final Buffer buffer;
        final Promise<Void> promise;

        Write(Buffer buffer, Promise<Void> promise) {
            this.buffer = buffer;
            this.promise = promise;
        }
    }
}

