/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.mojos;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.plugin.MojoExecution;

public class MojoSpy
extends AbstractExecutionListener {
    static final List<MojoExecution> MOJOS = new CopyOnWriteArrayList<MojoExecution>();
    static final List<String> PHASES = Arrays.asList("generate-sources", "process-sources", "generate-resources", "process-resources", "compile", "process-classes");
    private final MavenExecutionRequest request;
    private ExecutionListener delegate;

    private MojoSpy(MavenExecutionRequest request) {
        this.delegate = request.getExecutionListener();
        this.request = request;
    }

    public void projectDiscoveryStarted(ExecutionEvent executionEvent) {
        if (this.delegate != null) {
            this.delegate.projectDiscoveryStarted(executionEvent);
        }
    }

    public void sessionStarted(ExecutionEvent executionEvent) {
        if (this.delegate != null) {
            this.delegate.sessionStarted(executionEvent);
        }
    }

    public void sessionEnded(ExecutionEvent executionEvent) {
        if (this.delegate != null) {
            this.delegate.sessionEnded(executionEvent);
        }
    }

    public void projectSkipped(ExecutionEvent executionEvent) {
        if (this.delegate != null) {
            this.delegate.projectSkipped(executionEvent);
        }
    }

    public void projectStarted(ExecutionEvent executionEvent) {
        if (this.delegate != null) {
            this.delegate.projectStarted(executionEvent);
        }
    }

    public void projectSucceeded(ExecutionEvent executionEvent) {
        if (this.delegate != null) {
            this.delegate.projectSucceeded(executionEvent);
        }
        this.request.setExecutionListener(this.delegate);
    }

    public void projectFailed(ExecutionEvent executionEvent) {
        if (this.delegate != null) {
            this.delegate.projectFailed(executionEvent);
        }
        this.request.setExecutionListener(this.delegate);
    }

    public void mojoSkipped(ExecutionEvent executionEvent) {
        if (this.delegate != null) {
            this.delegate.mojoSkipped(executionEvent);
        }
    }

    public void mojoStarted(ExecutionEvent executionEvent) {
        if (this.delegate != null) {
            this.delegate.mojoStarted(executionEvent);
        }
    }

    public void mojoSucceeded(ExecutionEvent executionEvent) {
        MojoExecution execution = executionEvent.getMojoExecution();
        this.addExecutionIfNotContainedAlready(execution);
        if (this.delegate != null) {
            this.delegate.mojoSucceeded(executionEvent);
        }
    }

    private void addExecutionIfNotContainedAlready(MojoExecution execution) {
        String artifact = execution.getArtifactId();
        String id = execution.getExecutionId();
        for (MojoExecution exec : MOJOS) {
            if (!exec.getArtifactId().equals(artifact) || !exec.getExecutionId().equals(id)) continue;
            return;
        }
        MOJOS.add(execution);
    }

    public void mojoFailed(ExecutionEvent executionEvent) {
        if (this.delegate != null) {
            this.delegate.mojoFailed(executionEvent);
        }
    }

    public void forkStarted(ExecutionEvent executionEvent) {
        if (this.delegate != null) {
            this.delegate.forkStarted(executionEvent);
        }
    }

    public void forkSucceeded(ExecutionEvent executionEvent) {
        if (this.delegate != null) {
            this.delegate.forkSucceeded(executionEvent);
        }
    }

    public void forkFailed(ExecutionEvent executionEvent) {
        if (this.delegate != null) {
            this.delegate.forkFailed(executionEvent);
        }
    }

    public void forkedProjectStarted(ExecutionEvent executionEvent) {
        if (this.delegate != null) {
            this.delegate.forkedProjectStarted(executionEvent);
        }
    }

    public void forkedProjectSucceeded(ExecutionEvent executionEvent) {
        if (this.delegate != null) {
            this.delegate.forkedProjectSucceeded(executionEvent);
        }
    }

    public void forkedProjectFailed(ExecutionEvent executionEvent) {
        if (this.delegate != null) {
            this.delegate.forkedProjectFailed(executionEvent);
        }
    }

    public static void init(MavenExecutionRequest request) {
        request.setExecutionListener((ExecutionListener)new MojoSpy(request));
    }
}

