/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.mojos;

import io.reactiverse.vertx.maven.plugin.components.PackageConfig;
import io.reactiverse.vertx.maven.plugin.components.PackageService;
import io.reactiverse.vertx.maven.plugin.components.PackagingException;
import io.reactiverse.vertx.maven.plugin.components.ServiceFileCombinationConfig;
import io.reactiverse.vertx.maven.plugin.components.ServiceFileCombiner;
import io.reactiverse.vertx.maven.plugin.model.CombinationStrategy;
import io.reactiverse.vertx.maven.plugin.mojos.AbstractVertxMojo;
import io.reactiverse.vertx.maven.plugin.mojos.Archive;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class PackageMojo
extends AbstractVertxMojo {
    @Parameter(name="serviceProviderCombination", defaultValue="COMBINE")
    protected CombinationStrategy serviceProviderCombination;
    @Parameter(name="classifier")
    protected String classifier;
    @Parameter(name="attach", defaultValue="true")
    protected boolean attach;
    @Component
    protected PackageService packageService;
    @Component
    protected ServiceFileCombiner combiner;
    private static final String JAR_EXTENSION = ".jar";

    public static String computeOutputName(Archive archive, MavenProject project, String classifier) {
        String output = archive.getOutputFileName();
        if (!StringUtils.isBlank((CharSequence)output)) {
            if (!output.endsWith(JAR_EXTENSION)) {
                output = output + JAR_EXTENSION;
            }
            return output;
        }
        String finalName = project.getBuild().getFinalName();
        if (finalName != null) {
            if (finalName.endsWith(JAR_EXTENSION)) {
                finalName = finalName.substring(0, finalName.length() - JAR_EXTENSION.length());
            }
            if (classifier != null && !classifier.isEmpty()) {
                finalName = finalName + "-" + classifier;
            }
            finalName = finalName + JAR_EXTENSION;
            return finalName;
        }
        finalName = project.getArtifactId() + "-" + project.getVersion();
        if (classifier != null && !classifier.isEmpty()) {
            finalName = finalName + "-" + classifier;
        }
        finalName = finalName + JAR_EXTENSION;
        return finalName;
    }

    public void execute() throws MojoExecutionException {
        File jar;
        if (this.skip) {
            this.getLog().info((CharSequence)"vertx:package skipped by configuration");
            return;
        }
        this.fixEmptyClassifier();
        if (StringUtils.isBlank((CharSequence)this.classifier) && !this.attach) {
            throw new MojoExecutionException("Cannot disable attachment of the created archive when it's the main artifact");
        }
        Archive updatedArchive = this.computeArchive();
        this.combiner.doCombine((ServiceFileCombinationConfig)new ServiceFileCombinationConfig().setStrategy(this.serviceProviderCombination).setProject(this.project).setArchive(updatedArchive).setMojo(this).setArtifacts(this.project.getArtifacts()));
        try {
            jar = this.packageService.doPackage(((PackageConfig)new PackageConfig().setArtifacts(this.project.getArtifacts())).setMojo(this).setOutput(new File(this.projectBuildDir, PackageMojo.computeOutputName(this.archive, this.project, this.classifier))).setProject(this.project).setArchive(this.archive));
        }
        catch (PackagingException e) {
            throw new MojoExecutionException("Unable to build the fat jar", (Exception)e);
        }
        this.attachIfNeeded(jar);
    }

    private void attachIfNeeded(File jar) {
        if (jar.isFile() && this.classifier != null && this.attach) {
            DefaultArtifactHandler handler = new DefaultArtifactHandler("jar");
            DefaultArtifact vertxJarArtifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "compile", "jar", this.classifier, (ArtifactHandler)handler);
            vertxJarArtifact.setFile(jar);
            this.project.addAttachedArtifact((Artifact)vertxJarArtifact);
        }
    }

    private void fixEmptyClassifier() {
        if (StringUtils.isBlank((CharSequence)this.classifier)) {
            this.getLog().debug((CharSequence)"The classifier is empty, it won't be used");
            this.classifier = null;
        }
    }
}

