/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.mojos;

import io.reactiverse.vertx.maven.plugin.mojos.AbstractVertxMojo;
import io.reactiverse.vertx.maven.plugin.mojos.MojoSpy;
import io.reactiverse.vertx.maven.plugin.utils.ConfigConverterUtil;
import io.reactiverse.vertx.maven.plugin.utils.IncrementalBuilder;
import io.reactiverse.vertx.maven.plugin.utils.JavaProcessExecutor;
import io.reactiverse.vertx.maven.plugin.utils.MavenExecutionUtils;
import io.reactiverse.vertx.maven.plugin.utils.MojoExecutor;
import io.reactiverse.vertx.maven.plugin.utils.MojoUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;

public class AbstractRunMojo
extends AbstractVertxMojo {
    private static final String VERTXWEB_ENVIRONMENT = "VERTXWEB_ENVIRONMENT";
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    protected File classesDirectory;
    @Parameter(name="redeploy")
    protected boolean redeploy;
    @Parameter(alias="redeployScanPeriod", property="vertx.redeploy.scan.period", defaultValue="1000")
    long redeployScanPeriod;
    @Parameter(alias="redeployGracePeriod", property="vertx.redeploy.grace.period")
    long redeployGracePeriod;
    @Parameter(alias="redeployTerminationPeriod", property="vertx.redeploy.termination.period", defaultValue="1000")
    long redeployTerminationPeriod;
    @Parameter(property="vertxweb.environment")
    String vertxWebEnvironment;
    String vertxCommand = "run";
    @Parameter(alias="options", property="vertx.options")
    File options;
    @Parameter(alias="config", property="vertx.config")
    File config;
    @Parameter(alias="workDirectory", property="vertx.directory", defaultValue="${project.basedir}")
    File workDirectory;
    @Parameter(alias="jvmArgs", property="vertx.jvmArguments")
    protected List<String> jvmArgs;
    List<String> optionalRunExtraArgs;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"vertx:run skipped by configuration");
            return;
        }
        this.ensureVerticleOrLauncher();
        this.compileIfNeeded();
        ArrayList<String> argsList = new ArrayList<String>();
        this.options = this.scanAndLoad("options", this.options);
        if (this.options != null) {
            this.getLog().info((CharSequence)("Using options file: " + this.options.getAbsolutePath()));
        }
        this.config = this.scanAndLoad("application", this.config);
        if (this.config != null) {
            this.getLog().info((CharSequence)("Using configuration file: " + this.config.getAbsolutePath()));
        }
        boolean isVertxLauncher = this.isVertxLauncher(this.launcher);
        this.getLog().info((CharSequence)"Launching Vert.x Application");
        if (isVertxLauncher) {
            this.addVertxArgs(argsList);
        } else if (this.redeploy) {
            this.getLog().info((CharSequence)"Vert.x application redeploy enabled");
            argsList.add(0, "io.vertx.core.Launcher");
            argsList.add(1, "run");
            StringBuilder redeployArg = new StringBuilder();
            redeployArg.append("--redeploy=");
            this.computeOutputDirsWildcard(redeployArg);
            argsList.add(redeployArg.toString());
            this.addRedeployExtraArgs(argsList);
            argsList.add("--launcher-class");
            argsList.add(this.launcher);
            this.addJvmArgs(argsList);
        } else {
            argsList.add(this.launcher);
        }
        this.addRunExtraArgs(argsList);
        this.run(argsList);
    }

    private void ensureVerticleOrLauncher() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Checking that verticle or launcher is set: " + this.verticle + ", " + this.launcher));
        if (StringUtils.isBlank((CharSequence)this.verticle) && StringUtils.isBlank((CharSequence)this.launcher)) {
            throw new MojoExecutionException("Invalid configuration, the element `verticle` (`vertx.verticle` property) or the element `launcher` (`vertx.launcher` property) is required.");
        }
        if (this.launcher.equalsIgnoreCase("io.vertx.core.Launcher") && StringUtils.isBlank((CharSequence)this.verticle)) {
            throw new MojoExecutionException("Invalid configuration, the element `verticle` (`vertx.verticle` property) is required if the element `launcher` (`vertx.launcher` property) is not set (or is `io.vertx.core.Launcher`)");
        }
    }

    private void compileIfNeeded() {
        File classes = new File(this.project.getBuild().getOutputDirectory());
        if (!classes.isDirectory()) {
            MavenExecutionUtils.execute("compile", this.project, this.mavenSession, this.lifecycleExecutor, this.container);
        }
    }

    void addClasspath(List<String> args) throws MojoExecutionException {
        try {
            StringBuilder classpath = new StringBuilder();
            for (URL ele : this.getClassPathUrls()) {
                classpath.append(classpath.length() > 0 ? File.pathSeparator : "");
                classpath.append(new File(ele.toURI()));
            }
            if (SystemUtils.IS_OS_WINDOWS) {
                classpath.insert(0, '\"').append('\"');
            }
            this.getLog().debug((CharSequence)("Classpath for forked process: " + classpath));
            args.add("-cp");
            args.add(classpath.toString());
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Could not build classpath", ex);
        }
    }

    private void addClassesDirectory(List<URL> classpathUrls) throws IOException {
        classpathUrls.add(this.classesDirectory.toURI().toURL());
    }

    private void addVertxArgs(List<String> argsList) {
        Objects.requireNonNull(this.launcher);
        if ("io.vertx.core.Launcher".equals(this.launcher)) {
            argsList.add("io.vertx.core.Launcher");
        } else {
            argsList.add(this.launcher);
        }
        argsList.add(this.vertxCommand);
        if (this.verticle != null && !"stop".equals(this.vertxCommand)) {
            argsList.add(this.verticle);
        }
        this.handleRedeploy(argsList);
        if (!"stop".equals(this.vertxCommand)) {
            String argLauncherClass = "--launcher-class=\"" + this.launcher + "\"";
            argsList.add(argLauncherClass);
            if (this.options != null && this.options.exists() && this.options.isFile()) {
                this.getLog().info((CharSequence)("Using options from file: " + this.options.toString()));
                argsList.add("-options");
                argsList.add(this.options.toString());
            }
            if (this.config != null && this.config.exists() && this.config.isFile()) {
                this.getLog().info((CharSequence)("Using configuration from file: " + this.config.toString()));
                argsList.add("-conf");
                argsList.add(this.config.toString());
            }
        }
    }

    private void handleRedeploy(List<String> argsList) {
        if (this.redeploy && !"start".equals(this.vertxCommand) && !"stop".equals(this.vertxCommand)) {
            this.getLog().info((CharSequence)"Vert.x application redeploy enabled");
            StringBuilder redeployArg = new StringBuilder();
            redeployArg.append("--redeploy=");
            this.computeOutputDirsWildcard(redeployArg);
            argsList.add(redeployArg.toString());
            this.addRedeployExtraArgs(argsList);
            this.addJvmArgs(argsList);
        }
    }

    private void addJvmArgs(List<String> argsList) {
        if (this.jvmArgs != null && !this.jvmArgs.isEmpty()) {
            String javaOpts = SystemUtils.IS_OS_WINDOWS ? this.jvmArgs.stream().collect(Collectors.joining(" ", "\"", "\"")) : String.join((CharSequence)" ", this.jvmArgs);
            String argJavaOpts = "--java-opts=" + javaOpts;
            argsList.add(argJavaOpts);
        }
    }

    private void computeOutputDirsWildcard(StringBuilder redeployArg) {
        String wildcardClassesDir = this.classesDirectory.toString() + "/**/*";
        redeployArg.append(wildcardClassesDir);
    }

    private void addRedeployExtraArgs(List<String> argsList) {
        if (this.redeployScanPeriod > 0L) {
            argsList.add("--redeploy-scan-period=" + this.redeployScanPeriod);
        }
        if (this.redeployGracePeriod > 0L) {
            argsList.add("--redeploy-grace-period=" + this.redeployGracePeriod);
        }
        if (this.redeployTerminationPeriod > 0L) {
            argsList.add("redeploy-termination-period=" + this.redeployTerminationPeriod);
        }
    }

    private void addRunExtraArgs(List<String> argsList) {
        if ("run".equals(this.vertxCommand) && this.optionalRunExtraArgs != null && !this.optionalRunExtraArgs.isEmpty()) {
            argsList.addAll(this.optionalRunExtraArgs);
        }
    }

    boolean isVertxLauncher(String launcher) throws MojoExecutionException {
        if (launcher != null) {
            if ("io.vertx.core.Launcher".equals(launcher)) {
                return true;
            }
            try {
                Class<?> customLauncher = this.buildClassLoader(this.getClassPathUrls()).loadClass(launcher);
                List superClasses = ClassUtils.getAllSuperclasses(customLauncher);
                return AbstractRunMojo.lookupForLauncherInClassHierarchy(superClasses);
            }
            catch (ClassNotFoundException e) {
                this.getLog().error((CharSequence)("Unable to load the class " + launcher), (Throwable)e);
                throw new MojoExecutionException("Class \"" + launcher + "\" not found");
            }
        }
        return false;
    }

    private static boolean lookupForLauncherInClassHierarchy(List<Class<?>> superClasses) {
        boolean isAssignable = false;
        if (superClasses != null) {
            for (Class<?> superClass : superClasses) {
                if (!"io.vertx.core.Launcher".equals(superClass.getName())) continue;
                isAssignable = true;
                break;
            }
        }
        return isAssignable;
    }

    protected void run(List<String> argsList) throws MojoExecutionException {
        String webEnv = Optional.ofNullable(this.vertxWebEnvironment).orElse(Optional.ofNullable(System.getenv(VERTXWEB_ENVIRONMENT)).orElse("dev"));
        JavaProcessExecutor vertxExecutor = new JavaProcessExecutor().withJvmOpts(this.redeploy ? Collections.emptyList() : this.jvmArgs).withEnvVar(VERTXWEB_ENVIRONMENT, webEnv).withArgs(argsList).withClassPath(this.getClassPathUrls()).withLogger(this.getLog()).withWaitFor(true);
        try {
            if (this.redeploy && !"start".equals(this.vertxCommand) && !"stop".equals(this.vertxCommand)) {
                this.getLog().debug((CharSequence)("Collected mojos: " + MojoSpy.MOJOS));
                Set<Path> inclDirs = Collections.singleton(new File(this.project.getBasedir(), "src/main").toPath());
                Set artifacts = this.project.getArtifacts();
                Thread buildRunner = new Thread(() -> {
                    List<Callable<Void>> chain = this.computeExecutionChain(artifacts);
                    IncrementalBuilder incrementalBuilder = new IncrementalBuilder(inclDirs, chain, this.getLog(), this.redeployScanPeriod);
                    incrementalBuilder.run();
                });
                buildRunner.setDaemon(true);
                buildRunner.start();
            }
            vertxExecutor.execute();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to launch incremental builder", e);
        }
    }

    private List<Callable<Void>> computeExecutionChain(Set<Artifact> artifacts) {
        ArrayList<Callable<Void>> list = new ArrayList<Callable<Void>>();
        if (MojoSpy.MOJOS.isEmpty()) {
            this.getLog().info((CharSequence)"No plugin execution collected. The vertx:initialize goal has not been run beforehand. Only handling resources and java compilation");
            list.add(new JavaBuildCallback());
            list.add(new ResourceBuildCallback());
        } else {
            list = MojoSpy.MOJOS.stream().filter(exec -> MojoSpy.PHASES.contains(exec.getLifecyclePhase())).map(execution -> this.toTask((MojoExecution)execution, artifacts)).collect(Collectors.toList());
        }
        return list;
    }

    private Callable<Void> toTask(MojoExecution execution, Set<Artifact> artifacts) {
        MojoExecutor executor = new MojoExecutor(execution, this.project, this.mavenSession, this.buildPluginManager);
        return () -> {
            this.project.setArtifacts(artifacts);
            try {
                this.getLog().info((CharSequence)(">>> " + execution.getArtifactId() + ":" + execution.getVersion() + ":" + execution.getGoal() + " (" + execution.getExecutionId() + ") @" + this.project.getArtifactId()));
                executor.execute();
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Error while doing incremental build", (Throwable)e);
            }
            return null;
        };
    }

    private File lookForConfiguration(String filename) {
        File confBaseDir = new File(this.project.getBasedir(), "src/main/conf");
        if (!confBaseDir.isDirectory()) {
            return null;
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(confBaseDir);
        String[] includes = (String[])Stream.concat(Stream.of(".json"), YAML_EXTENSIONS.stream()).map(ext -> filename + ext).toArray(String[]::new);
        directoryScanner.setIncludes(includes);
        directoryScanner.scan();
        return Arrays.stream(directoryScanner.getIncludedFiles()).map(found -> new File(confBaseDir, (String)found)).findFirst().orElse(null);
    }

    File scanAndLoad(String configName, File userProvided) throws MojoExecutionException {
        File file;
        if (userProvided != null) {
            if (!userProvided.isFile()) {
                this.getLog().error((CharSequence)("Cannot load the configuration - file " + userProvided.getAbsolutePath() + " does not exist"));
                return userProvided;
            }
            file = userProvided;
        } else {
            file = this.lookForConfiguration(configName);
            if (file == null) {
                this.getLog().debug((CharSequence)"No configuration found");
                return null;
            }
        }
        return this.isYaml(file) ? this.convertYamlToJson(file) : file;
    }

    private File convertYamlToJson(File yamlFile) throws MojoExecutionException {
        File jsonConfDir = new File(this.projectBuildDir, "conf");
        boolean created = jsonConfDir.mkdirs();
        this.getLog().debug((CharSequence)("Config directory " + jsonConfDir.getAbsolutePath() + " created: " + created));
        String output = FilenameUtils.removeExtension((String)yamlFile.getName()) + ".json";
        File convertedJsonFile = new File(jsonConfDir, output);
        try {
            ConfigConverterUtil.convertYamlToJson(yamlFile, convertedJsonFile);
            this.getLog().info((CharSequence)(yamlFile.getAbsolutePath() + " converted to " + convertedJsonFile.getAbsolutePath()));
            return convertedJsonFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error loading or converting the configuration file:" + yamlFile, e);
        }
    }

    private ClassLoader buildClassLoader(Collection<URL> classPathUrls) {
        return new URLClassLoader(classPathUrls.toArray(new URL[0]));
    }

    private List<URL> getClassPathUrls() throws MojoExecutionException {
        ArrayList<URL> classPathUrls = new ArrayList<URL>();
        try {
            this.addClassesDirectory(classPathUrls);
            Set<Optional<File>> compileAndRuntimeDeps = this.extractArtifactPaths(this.project.getDependencyArtifacts());
            Set<Optional<File>> transitiveDeps = this.extractArtifactPaths(this.project.getArtifacts());
            classPathUrls.addAll(Stream.concat(compileAndRuntimeDeps.stream(), transitiveDeps.stream()).filter(Optional::isPresent).map(file -> {
                try {
                    return ((File)file.get()).toURI().toURL();
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)"Error building classpath", (Throwable)e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to run:", (Exception)e);
        }
        return classPathUrls;
    }

    private boolean isYaml(File file) {
        return file != null && YAML_EXTENSIONS.stream().anyMatch(ext -> file.getName().endsWith((String)ext));
    }

    public final class ResourceBuildCallback
    implements Callable<Void> {
        @Override
        public Void call() {
            try {
                MojoUtils.copyResources(AbstractRunMojo.this.project, AbstractRunMojo.this.mavenSession, AbstractRunMojo.this.buildPluginManager);
            }
            catch (Exception e) {
                AbstractRunMojo.this.getLog().error((CharSequence)("Error while doing incremental resource processing: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    public final class JavaBuildCallback
    implements Callable<Void> {
        @Override
        public Void call() {
            try {
                MojoUtils.compile(AbstractRunMojo.this.project, AbstractRunMojo.this.mavenSession, AbstractRunMojo.this.buildPluginManager);
            }
            catch (Exception e) {
                AbstractRunMojo.this.getLog().error((CharSequence)("Error while doing incremental Java build: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }
}

