/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.utils;

import io.reactiverse.vertx.maven.plugin.mojos.AbstractVertxMojo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.logging.Log;

public class WebJars {
    private static final Pattern WEBJAR_REGEX = Pattern.compile(".*META-INF/resources/webjars/([^/]+)/([^/]+)/.*");
    private static final String WEBJAR_LOCATION = "META-INF/resources/webjars/";
    private static final Pattern WEBJAR_INTERNAL_PATH_REGEX = Pattern.compile("([^/]+)/([^/]+)/(.*)");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isWebJar(Log log, File file) {
        if (file == null) {
            return false;
        }
        LinkedHashSet<String> found = new LinkedHashSet<String>();
        if (!file.isFile()) return false;
        if (!file.getName().endsWith(".jar")) return false;
        try (JarFile jar = new JarFile(file);){
            if (jar.getEntry(WEBJAR_LOCATION) == null) {
                boolean bl = false;
                return bl;
            }
            WebJars.search(found, jar);
        }
        catch (IOException e) {
            log.error((CharSequence)("Cannot check if the file " + file.getName() + " is a webjar, cannot open it"), (Throwable)e);
            return false;
        }
        for (String lib : found) {
            log.info((CharSequence)("Web Library found in " + file.getName() + " : " + lib));
        }
        if (found.isEmpty()) return false;
        return true;
    }

    private static void search(Set<String> found, JarFile jar) {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            Matcher matcher = WEBJAR_REGEX.matcher(entry.getName());
            if (!matcher.matches()) continue;
            found.add(matcher.group(1) + "-" + matcher.group(2));
        }
    }

    public static void extract(AbstractVertxMojo mojo, File in, File out, boolean stripVersion) throws IOException {
        try (ZipFile file = new ZipFile(in);){
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                WebJars.unzipWebJarFile(mojo, out, stripVersion, file, entries);
            }
        }
    }

    private static void unzipWebJarFile(AbstractVertxMojo mojo, File out, boolean stripVersion, ZipFile file, Enumeration<? extends ZipEntry> entries) throws IOException {
        ZipEntry entry = entries.nextElement();
        if (entry.getName().startsWith(WEBJAR_LOCATION) && !entry.isDirectory()) {
            File output = WebJars.getOutput(mojo.getLog(), out, stripVersion, entry.getName().substring(WEBJAR_LOCATION.length()));
            try (InputStream stream = file.getInputStream(entry);){
                boolean created = output.getParentFile().mkdirs();
                mojo.getLog().debug((CharSequence)(out.getParentFile().getAbsolutePath() + " created? " + created));
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)output);
            }
            catch (IOException e) {
                mojo.getLog().error((CharSequence)("Cannot unpack " + entry.getName() + " from " + file.getName()), (Throwable)e);
                throw e;
            }
        }
    }

    private static File getOutput(Log log, File out, boolean stripVersion, String path) {
        if (stripVersion) {
            Matcher matcher = WEBJAR_INTERNAL_PATH_REGEX.matcher(path);
            if (matcher.matches()) {
                return new File(out, matcher.group(1) + "/" + matcher.group(3));
            }
            log.warn((CharSequence)(path + " does not match the regex - did not strip the version for this file"));
        }
        return new File(out, path);
    }
}

